<?php
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);

if (isset($_POST['jenis'])) {
    $jenis_lap = $_POST['jenis'];
} else {
    $jenis_lap = "Semua";
};
if (isset($_POST['jenjang'])) {
    $jenjang_lap = $_POST['jenjang'];
    $jenjang_post = $_POST['jenjang'];
    $aktifjenis = "";
} else {
    $jenjang_lap = "--Pilih--";
    $jenjang_post = "Semua";
    $aktifjenis = "disabled";
};
if (isset($_POST['paralel'])) {
    $paralel_lap = $_POST['paralel'];
} else {
    $paralel_lap = "Semua";
};


$dt_jenis = new namaBayar();
$showJenis = $dt_jenis->shownamaBayar($tahun, $jenis_lap, $jenjang_lap);
$count_nb = $showJenis->rowCount();
$datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
if ($count_nb > 0) {
    $namaBayar = $datajenis->nama;
} else {
    $namaBayar = "Semua";
};

//Query Tanggungan
$classTanggungan = new listTanggungan();
$val_sumtang = $classTanggungan->sumTanggunganByFilter($tb_siswa, $jenjang_post, $paralel_lap, $jenis_lap);

if ($val_sumtang == "" || $val_sumtang  == 0 || isset($_POST['jenjang']) == NULL) {
    $sumtanggungan = number_format(0, 0, ",", ".");
    $v_sumtanggungan = 0;
} else {
    $sumtanggungan = number_format($val_sumtang, 0, ",", ".");
    $v_sumtanggungan = $val_sumtang;
};

//Terbayar & Kurang
if (isset($_POST['jenjang']) == NULL) {
    $terbayar = @(number_format(0, 0, ".", "."));
    $kurang = @(number_format(0, 0, ".", "."));;
} else {
    $classTrans = new transaksi();
    $Terbayar = $classTrans->sumTerbayar($tb_transaksi, $jenjang_post, $paralel_lap, $jenis_lap);
    $terbayar = @(number_format($Terbayar, 0, ".", "."));
    $kurang = $v_sumtanggungan - $Terbayar;
    $kurang = @(number_format(($kurang), 0, ".", "."));
};



//Indo to Egg
function ubahformatTgl($tanggal)
{
    $pisah = explode('-', $tanggal);
    $urutan = array($pisah[2], $pisah[1], $pisah[0]);
    $satukan = implode('-', $urutan);
    return $satukan;
}

?>

<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="card-header bg-primary">
                            <b class="card-title text-light judul"><span class="bi bi-journal-text"></span> Laporan Rekapitulasi Model-1 </b>
                        </div>
                        <div class="card-body mb-0">
                            <div class="row mx-3 mt-2" style="background-color: gainsboro;">
                                <div class="col-md-6">
                                    <div class="card-body mt-4 px-1 mx-2">
                                        <form action="" method="post">

                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Kelas [Jenjang-Paralel]</label>
                                                <div class="col-md-2">
                                                    <select name="jenjang" class="form-control form-control-sm fontInput small" onchange="this.form.submit()">

                                                        <option><?php echo $jenjang_lap; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        $data_sekolah = new crudData;
                                                        $sekolah = $data_sekolah->editData('sekolah', 'no', 1);
                                                        $dataSekolah = $sekolah->fetch(PDO::FETCH_OBJ);
                                                        $jenjang = strtolower($dataSekolah->jenjang);

                                                        $opt = new form();
                                                        $opval = $opt->optSelect('tb_tingkat', "where {$jenjang}<>'' order by no asc");
                                                        while ($dataopt = $opval->fetch(PDO::FETCH_OBJ)) {
                                                            $optJenjang = $dataopt->{$jenjang};
                                                            echo "<option>" . $optJenjang . " </option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-7">
                                                    <select name="paralel" class="form-control form-control-sm fontInput small" required onchange="this.form.submit()">
                                                        <option><?php echo $paralel_lap; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        $opval = $opt->optSelect('tb_paralel', ' order by no asc');
                                                        while ($datapar = $opval->fetch(PDO::FETCH_OBJ)) {
                                                            echo "<option>$datapar->paralel</option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Jenis Pembayaran</label>
                                                <div class="col-md-9">
                                                    <select name="jenis" class="form-control form-control-sm fontInput small" required <?php echo $aktifjenis; ?> onchange="this.form.submit()">
                                                        <option value="<?php echo $jenis_lap; ?>"><?php echo $jenis_lap . " : " . $namaBayar; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        // $dt_jenis = new namaBayar();
                                                        $showJenis = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $jenjang_lap, 'kode');
                                                        $count = $showJenis->rowCount();
                                                        while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
                                                            echo "<option value='$datajenis->kode'>$datajenis->kode : $datajenis->nama</option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row mt-3">
                                                <label class="col-sm-3 col-form-label"></label>
                                                <div class="col-md-9">
                                                    <button type="submit" class="btn btn-primary btn-xs float-right px-2 mx-1" name="save"><i class="bi-funnel"></i> <b>FILTER</b></button>
                                        </form>

                                        <?php echo $link->exportXlsxLapRekap1('laporan/rekapitulasi/print_excel_1', $tahun,  $jenjang_post, $paralel_lap, $jenis_lap); ?>

                                        <form name="cetak" action="<?php echo $link->pageAction('laporan/rekapitulasi/print_preview'); ?>" method="post">
                                            <input name="model" value="1" hidden>
                                            <input name="tahun" value="<?php echo $tahun; ?>" hidden>
                                            <input name="jenis" value="<?php echo $jenis_lap; ?>" hidden>
                                            <input name="jenjang" value="<?php echo $jenjang_post; ?>" hidden>
                                            <input name="paralel" value="<?php echo $paralel_lap; ?>" hidden>
                                            <button type="submit" class="btn btn-primary btn-xs float-right px-2 mx-1 d-inline"><i class="bi bi-printer"></i><b> CETAK</b></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card-body mt-4 px-1 mx-2">
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <div class="info-box mb-3">
                                            <span class="info-box-icon bg-primary elevation-1"><i class="bi bi-journal-text"></i></span>
                                            <div class="info-box-content">

                                                <div class="col-sm-12 invoice-col">
                                                    <dl class="row">

                                                        <dt class="col-sm-4 pt-3">JML TANGGUNGAN</dt>
                                                        <dd class="col-sm-8 pt-3"><b>: <?php echo $sumtanggungan; ?></b></dd>
                                                        <dt class="col-sm-4">JML TERBAYAR</dt>
                                                        <dd class="col-sm-8 "><b>: <?php echo $terbayar; ?> </b></dd>
                                                        <dt class="col-sm-4">JML KURANG</dt>
                                                        <dd class="col-sm-8"><b>: <?php echo $kurang; ?></b>
                                                        </dd>
                                                    </dl>
                                                </div>



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>


                <div class="card-body mx-4">
                    <label>
                        <h6><b class="text-primary">REKAPITULASI</b></h6>
                    </label>
                    <table id="example51" class="table table-bordered table-striped table-hover table-sm mb-4">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama</th>
                                <th>NIS</th>
                                <th>Kelas</th>
                                <th>Tanggungan</th>
                                <th>Terbayar</th>
                                <th>Kurang</th>
                                <th>Detail</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php
                            $classLaporan = new Laporan();
                            $showList = $classLaporan->showRekap($tb_siswa, $jenjang_lap, $paralel_lap, 'jenjang asc, paralel asc, nama asc');
                            $no = 0;
                            while ($data = $showList->fetch(PDO::FETCH_OBJ)) {

                                $nis = $data->nis;
                                $id = $data->id;
                                $nama = $data->nama;
                                $jenjang = $data->jenjang;
                                $paralel = $data->paralel;
                                $kelas = $jenjang . '-' . $paralel;

                                //Query Tanggungan
                                $classTanggungan = new listTanggungan();
                                $val_tang = $classTanggungan->tanggunganByKode($tb_siswa, 'id', $id, $jenis_lap);
                                if ($val_tang == "" || $val_tang  == 0) {
                                    $tanggungan = number_format(0, 0, ",", ".");
                                    $v_tanggungan = 0;
                                } else {
                                    $tanggungan = number_format($val_tang, 0, ",", ".");
                                    $v_tanggungan = $val_tang;
                                };
                                //Terbayar & Kurang
                                $classTrans = new Transaksi();
                                $Terbayar = $classTrans->infoterbayarIf($tb_transaksi, $nis, $jenis_lap);
                                $terbayar = @(number_format($Terbayar, 0, ".", "."));
                                $kurang = $v_tanggungan - $Terbayar;
                                $kurang = @(number_format(($kurang), 0, ".", "."));

                                $no++;
                                $link = new linkpage;
                                echo "
                                    <tr>
                                        <td width='5px'>$no</td>
                                        <td align=left>$nama</td>
                                        <td align=left>$nis</td>
                                        <td align=left>$kelas</td>
                                        <td align=left>$tanggungan</td>
                                        <td align=left>$terbayar</td>
                                        <td align=left>$kurang</td>
                                        <td width='50px' align='center'>
                                      
                                        </td>
                                    </tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>