<?php



require "../../../asset/mod/autoLoad.php";
require "../layout/session.php";

$grafik = new aks_grafik;
$lembaga = new lembaga;
$time = new time;


if ((int)substr($time->getDate(), 5, 2) > 6) {
	$blnNow = (int)substr($time->getDate(), 5, 2) - 6;
} else {
	$blnNow = (int)substr($time->getDate(), 5, 2) + 6;
}

if (isset($_POST['bulan'])) {
	$bulan = $_POST['bulan'];
	$periode = $lembaga->valPeriodeEng($bulan, $tahun1, $tahun2);
	$v_bulan = $lembaga->ValPeriode($bulan, $tahun1, $tahun2);
} else {
	$bulan = $lembaga->nowPeriode();
	$periode = $lembaga->valPeriodeEng($blnNow, $tahun1, $tahun2);
	$v_bulan = $lembaga->ValPeriode($blnNow, $tahun1, $tahun2);
};


$realisasiHari = $grafik->realisasiHari($tb_transaksi, $periode);

?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="<?php
				$logo = new dirImage;
				echo $logo->dirImg('../dokumen/foto/', 'logo');
				?>" rel='shortcut icon'>

	<title>AKS || <?php echo $clasSekolah->dataSekolah('sekolah'); ?></title>

	<link rel="stylesheet" href="../../../asset/bootstrap/css/adminlte.min.css">
	<script src="../../../asset/bootstrap/plugins/chart/dist/Chart.bundle.js"></script>
	<script src="../../../asset/bootstrap/plugins/chart/utils.js"></script>
	<style>
		.loader {
			background-color: white;
			opacity: 0.7;
			margin: auto;
			z-index: 99999999;
			-webkit-animation: spin 2s linear infinite;
			animation: spin 2s linear infinite;
		}
	</style>
</head>
<style>
	canvas2 {
		-moz-user-select: none;
		-webkit-user-select: none;
		-ms-user-select: none;
	}
</style>
<div class="col-sm-12 invoice-col">
	<form action="" method="post">
		<div class="row">
			<label class="col-sm-2 col-form-label">Periode</label>
			<div class="col-sm-7">
				<select name="bulan" class="form-control col-lg-5 form-control-sm fontInput">
					<option value="<?php echo $bulan; ?>"><?php echo $v_bulan; ?></option>
					<?php
					$oplist = $lembaga->listPeriode($tahun1, $tahun2);
					echo $oplist;
					?>
				</select>
			</div>
			<div class="col-sm-2 pt-1">
				<button type="submit" class="btn btn-primary btn-xs float-left " name="submit"><i class="bi bi-funnel"></i> <b> SUBMIT</b></button>

			</div>
		</div>

	</form>

</div>

<div id="container" style="width: 100%;">
	<canvas class="img-responsive" id="canvas2"></canvas>
	<i style="font-size:9px; font-family:arial color=green">Copyright (c) 2018 Chart.js Contributors</i>
</div>

<script>
	var chartDataHari = {
		labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31'],
		datasets: [
			<?php
			$crud = new crudData;
			$jenjang = strtolower($crud->getValue('sekolah', "where no>0", 'jenjang'));
			$opt = new form();
			$opval = $opt->optSelect('tb_tingkat', "where {$jenjang}<>'' order by no asc");
			while ($dataopt = $opval->fetch(PDO::FETCH_OBJ)) {
				$v_jenjang = $dataopt->{$jenjang};
				$tingkat = $dataopt->tingkat;
				$color = $grafik->lineColor($tingkat);
				echo $grafik->chartHariperJenjang($tb_transaksi, $periode, $v_jenjang, $color);
			};

			?>

			{
				type: 'bar',
				label: 'Penerimaan',
				backgroundColor: window.chartColors.default,
				data: [<?php echo $realisasiHari; ?>],
				borderColor: '',
				borderWidth: 2
			}
		]

	};
	window.onload = function() {
		var ctx = document.getElementById('canvas2').getContext('2d');
		window.myMixedChart = new Chart(ctx, {
			type: 'bar',
			data: chartDataHari,
			options: {
				responsive: true,
				title: {
					display: true,
					text: ''
				},
				tooltips: {
					mode: 'index',
					intersect: true
				}
			}
		});
	};
	document.getElementById('randomizeData').addEventListener('click', function() {
		chartData.datasets.forEach(function(dataset) {
			dataset.data = dataset.data.map(function() {
				return randomScalingFactor();
			});
		});
		window.myMixedChart.update();
	});
</script>

</body>

</html>