<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class simakom_laporan
{

    //Kegiatan
    public function jenisBuku($post)
    {
        if ($post == 1) {
            $value = "Buku Kas Umum";
        } elseif ($post == 2) {
            $value = "Buku Pembantu Kas Tunai";
        } elseif ($post == 3) {
            $value = "Buku Pembantu Kas Bank";
        } elseif ($post == 4) {
            $value = "Buku Pembantu Pajak";
        };
        return $value;
    }

    public function jenisTunai()
    {
        $value = "(jenis = '11' || jenis = '13' || jenis = '15' || jenis = '31' || jenis = '33' || jenis = '35' || jenis = '21' || jenis='22' || jenis='41' || jenis='43' || jenis='45' || jenis='47')";
        return $value;
    }
    public function jenisBank()
    {
        $value = "(jenis = '12' || jenis = '14' || jenis = '16' || jenis = '32' || jenis = '34' || jenis = '36' || jenis = '21' || jenis='22' || jenis='42' || jenis='44' || jenis='46' || jenis='48')";
        return $value;
    }

    public function jenisPajak()
    {
        $value = "(jenis = '13' || jenis = '14' || jenis = '33' || jenis = '34')";
        return $value;
    }
    public function jenisPiutang()
    {
        $value = "(jenis = '45' || jenis = '46' || jenis = '47' || jenis = '48')";
        return $value;
    }
    public function jenisHutang()
    {
        $value = "(jenis = '41' || jenis = '42' || jenis = '43' || jenis = '44')";
        return $value;
    }
    public function rangePeriode($periode, $tahun, $fieldTanggal)
    {
        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);

        $tanggal1 = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal2 = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-' . $lastDate);

        $value = "$fieldTanggal>='$tanggal1' && $fieldTanggal<='$tanggal2'";
        return $value;
    }



    public function summarySAPiutang($tb_transaksi, $periode, $tahun)
    {
        //Jumlah Akhir
        $filterPiutang = $this->jenisPiutang();

        // $saldoKasPiutang = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterPiutang, '1');
        $saldoKasPiutang = $this->piutangBulanLalu($periode, $tahun, $tb_transaksi);
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterPiutang");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterPiutang");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];


        $SAPiutang = ($saldoKasPiutang - $jumlahDebet + $jumlahKredit);
        return $SAPiutang;
    }
    public function summarySAHutang($tb_transaksi, $periode, $tahun)
    {
        //Jumlah Akhir
        $filterHutang = $this->jenisHutang();

        // $saldoKasHutang = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterHutang, '1');
        $saldoKasHutang = $this->hutangBulanLalu($periode, $tahun, $tb_transaksi);
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $db = database::getInstance();

        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterHutang");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterHutang");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];


        $SAHutang = ($saldoKasHutang + $jumlahDebet - $jumlahKredit);
        // $SAHutang = ($jumlahDebet);
        return $SAHutang;
    }

    public function summarySABKU($tb_transaksi, $periode, $tahun)
    {
        $saldoBKU = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where  $rangePeriode ");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $saldoBKU;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where  $rangePeriode ");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $SABKU = ($jumlahDebet  - $jumlahKredit);
        return $SABKU;
    }

    public function summarySATunai($tb_transaksi, $periode, $tahun)
    {
        //Jumlah Akhir
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);
        $filterTunai = $this->jenisTunai();

        $saldoKasTunai = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterTunai, '2');
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');


        $db = database::getInstance();

        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        //PU Bank
        // $tarik
        $SATunai = ($saldoKasTunai + $jumlahDebet + $tarikTunai - $jumlahKredit - $setorBank);
        //$SATunai = $saldoKasTunai;
        return $SATunai;
    }
    public function sx()
    {
        $crud = new crudData;
        $sekolah = new sekolah;
        $lemb = new lembaga;
        $time = new time;
        $lembaga = $sekolah->dataSekolah('sekolah');
        $jenjang = $sekolah->dataSekolah('jenjang');
        $id = $sekolah->dataSekolah('id');
        $tanggal = $crud->getValueElse('serial', "where id='$id'", 'tanggal', $time->getDate());
        $Dtgl = substr($tanggal, 9, 1);
        if (strlen($lembaga) >= 32) {
            $lenLembaga = strlen($lembaga) - 32;
        } elseif (strlen($lembaga) < 32 && strlen($lembaga) > 20) {
            $lenLembaga = strlen($lembaga) - 5;
        } else {
            $lenLembaga = strlen($lembaga);
        };
        $jj = $lemb->shortJenjang($jenjang);
        $val1 = strtoupper(substr(md5($lembaga), $Dtgl, 3) . substr(md5($id), $lenLembaga, 3));
        $val2 = strtoupper(substr(md5($jenjang), $Dtgl + 5, 3) . substr(md5($lembaga), $lenLembaga + 2, 2) . substr($jj, 0, 1));
        $val3 = strtoupper(substr(md5($id), $lenLembaga + 1, 3) . substr(md5($tanggal), $lenLembaga, 3));
        $val4 = strtoupper(substr(md5($lembaga), $Dtgl + 5, 2) . substr(md5($jj), 1, 1) . substr(md5($id), $lenLembaga, 3));
        $val5 = strtoupper(substr(md5($tanggal), $Dtgl + 6, 3) . substr(md5($lembaga), $lenLembaga + 3, 3));
        return trim($val1 . "-" . $val2 . "-" . $val3 . "-" . $val4 . "-" . $val5);
    }
    public function atx()
    {
        $sekolah = new sekolah;
        $lemb = new lembaga;
        $time = new time;
        $crud = new crudData;
        $lembaga = $sekolah->dataSekolah('sekolah');
        $jenjang = $sekolah->dataSekolah('jenjang');
        $id = $sekolah->dataSekolah('id');
        $tanggal = $crud->getValueElse('serial', "where id='$id'", 'tanggal', $time->getDate());
        $Dtgl = substr($tanggal, 9, 1);
        if (strlen($lembaga) >= 32) {
            $lenLembaga = strlen($lembaga) - 32;
        } elseif (strlen($lembaga) < 32 && strlen($lembaga) > 20) {
            $lenLembaga = strlen($lembaga) - 5;
        } else {
            $lenLembaga = strlen($lembaga);
        };
        $jj = $lemb->shortJenjang($jenjang);
        $val1 = strtoupper(substr(md5($lembaga), 12, 3) . substr(md5($id), 15, 1) . substr($jj, 1, 1));
        $val2 = strtoupper(substr(md5($jj), 10, 2) . substr(md5($lembaga), 20, 3));
        $val3 = strtoupper(substr(md5($jenjang), $lenLembaga + 3, 3) . substr(md5($tanggal), 2, 2));
        $val4 = strtoupper(substr(md5($val1), 4, 2) . substr($val2, 13, 1) . substr(md5($id), $lenLembaga, 2));
        $val5 = strtoupper(md5($val1 . $val2 . $val3 . $val4));
        return trim($val1 . $val2 .  $val3 .  $val4 . $val5);
    }
    public function getJenjang($sn, $akt)
    {
        $lemb = new lembaga;
        $val = substr($sn, 12, 1) . substr($akt, 4, 1);
        $value = $lemb->longJenjang($val);
        return $value;
    }
    public function sxatx()
    {
        $sekolah = new sekolah;
        $crud = new crudData;
        $lembaga = $sekolah->dataSekolah('sekolah');
        $jenjang = $sekolah->dataSekolah('jenjang');
        $id = $sekolah->dataSekolah('id');
        $tanggal = $crud->getValue('serial', "where id='$id'", 'tanggal');
        $sx = $crud->getValue('serial', "where id='$id'", 'seri');
        $ax = $crud->getValue('serial', "where id='$id'", 'aktivasi');
        if ($this->sx() == $sx && $this->atx() == $ax) {
            $value = true;
        } else {
            $value = false;
        };
        return $value;
    }

    public function summarySABank($tb_transaksi, $periode, $tahun)
    {
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);
        $filterBank = $this->jenisBank();

        $saldoKasBank = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterBank, '3');
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $db = database::getInstance();

        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $SABank = ($saldoKasBank + $jumlahDebet - $jumlahKredit + $setorBank - $tarikTunai);
        return $SABank;
    }
    public function summarySAPajak($tb_transaksi, $periode, $tahun)
    {

        $filterPajak = $this->jenisPajak();
        $saldoKasPajak = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterPajak, '4');
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $db = database::getInstance();

        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $SAPajak = ($saldoKasPajak + $jumlahDebet - $jumlahKredit);
        return $SAPajak;
    }

    public function deskripsiBKU($tb_transaksi, $periode, $tahun, $tanggal)
    {
        $format = new format();
        $hari = $format->hari($tanggal);
        $tanggal = $format->dateToIndoLong($tanggal);
        $optVal = new lembaga();
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);
        $v_bulan = $optVal->ValPeriode($periode, $tahun1, $tahun2);

        echo "<div class='col-sm-12 invoice-col'>
                <div class='col-md-12'>Pada hari ini $hari tanggal $tanggal, Buku Kas Umum bulan $v_bulan  ditutup dengan keadaan / kondisi Buku sebagai berikut : </div>
                <div class='col-md-12'>
                <dl class='row'>
                    <dd class='col-sm-4'>Saldo Buku Kas</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySABKU($tb_transaksi, $periode, $tahun)) . "</dd>
                    <dd class='col-sm-4'>Terdiri dari :</dd>
                    <dd class='col-sm-8 '></dd>
                    <dd class='col-sm-4'>- Saldo Kas Tunai</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySATunai($tb_transaksi, $periode, $tahun)) . "</dd>
                    <dd class='col-sm-4'>- Saldo Kas Bank</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySABank($tb_transaksi, $periode, $tahun)) . "</dd>
               
                   </dl>
                   </div>
             </div>";
    }

    public function penandaTangan($tanggal, $tahun)
    {
        $clssekolah = new sekolah();

        // include "sekolah.php";

        $simakom_bendahara_nama = $clssekolah->dataSekolah('simakom_bendahara_nama');
        $simakom_bendahara_nip = $clssekolah->dataSekolah('simakom_bendahara_nip');
        $simakom_atasan_nama = $clssekolah->dataSekolah('simakom_atasan_nama');
        $simakom_atasan_nip = $clssekolah->dataSekolah('simakom_atasan_nip');
        $simakom_atasan_jabatan = $clssekolah->dataSekolah('simakom_atasan_jabatan');

        $format = new format();

        $tanggal = $format->dateToIndoLong($tanggal);


        echo "<div class='row col-sm-12 ml-5'><div class='col-sm-12 '>
                <div class='col-lg-12'>
                <dl class='row'>
                <dd class='col-sm-8'>Mengetahui,<br>$simakom_atasan_jabatan</dd>
                <dd class='col-sm-4'>" . $clssekolah->dataSekolah('kota') . ", $tanggal<br>Bendahara</dd>    
                <dd class='col-sm-8 mt-5'>$simakom_atasan_nama<br>NIP. $simakom_atasan_nip</dd>
                <dd class='col-sm-4 mt-5'>$simakom_bendahara_nama<br>NIP. $simakom_bendahara_nip</dd>                 
                </dl>
             </div>
             </div>";
    }

    public function summary($tb_transaksi, $periode, $tahun, $tanggal)
    {
        $format = new format();
        $hari = $format->hari($tanggal);
        $tanggal = $format->dateToIndoLong($tanggal);
        $optVal = new lembaga();
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);
        $v_bulan = $optVal->ValPeriode($periode, $tahun1, $tahun2);

        echo "<div class='col-sm-12 invoice-col'>
                <div class='col-md-12'>
                <dl class='row'>
                    <dd class='col-sm-4'>Saldo Buku Kas</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySABKU($tb_transaksi, $periode, $tahun)) . "</dd>
                    <dd class='col-sm-4'>Terdiri dari :</dd>
                    <dd class='col-sm-8 '></dd>
                    <dd class='col-sm-4'>- Saldo Kas Tunai</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySATunai($tb_transaksi, $periode, $tahun)) . "</dd>
                    <dd class='col-sm-4'>- Saldo Kas Bank</dd>
                    <dd class='col-sm-8'>: " . $format->ribuan($this->summarySABank($tb_transaksi, $periode, $tahun)) . "</dd>
               
                   </dl>
                   </div>
             </div>";
    }

    public function list_bku($tb_transaksi, $periode, $tahun, $tanggalBuku)
    {

        $format = new format();

        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        $saldoAwal = $format->ribuan($vsaldo);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        if ($periode == 1) {
            echo "";
        } else {
            echo " <tr>
            <td align=center width='5px'>-</td>
            <td align=center>--</td>
            <td align=center>--</td>
            <td align=left>Saldo Awal</td>
            <td align=right>$saldoAwal</td>
            <td align=right>0</td>
            <td align=right>$saldoAwal</td>
         </tr>";
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;

        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;

                $saldo = ($saldo + $debet - $kredit);


                echo "
                <tr>
                    <td align=center width='5px'>$no</td>
                    <td align=center> $kategori.$data->jenis-$data->bukti</td>
                    <td align=center>$tanggal</td>
                    <td align=left>" . $format->entityEncode($data->uraian) . "</td>
                    <td align=right>" . $format->ribuan($debet) . "</td>
                    <td align=right>" . $format->ribuan($kredit) . "</td>
                    <td align=right>" . $format->ribuan($saldo) . "</td>
                </tr>";
                $no++;
            }
        } else {
            echo  "<tr>
                <td align=center colspan='4'>-- N I H I L --</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>$saldoAwal</td>
            </tr>";
        };



        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        if ($jumlahDebet == 0) {
            $debet = 0;
        } else {
            $debet = $format->ribuan($jumlahDebet);
        };

        echo " <tr>
                <td width='5px' colspan='4' align='center'><b>Jumlah</b></td>
                <td align=right><b>" . $format->ribuan($jumlahDebet)  . "</b></td>
                <td align=right><b>" . $format->ribuan($jumlahKredit) . "</b></td>
                <td align=right><b>" . $format->ribuan($saldoAkhir) . "</b></td>
            </tr>";
    }
    public function list_bku_word($tb_transaksi, $periode, $tahun, $table)
    {

        $format = new format();

        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        $saldoAwal = $format->ribuan($vsaldo);

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;

        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;

                $saldo = ($saldo + $debet - $kredit);

                $table->addRow(300, '');
                $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($no), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($kategori . $data->jenis - $data->bukti), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($tanggal), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($data->uraian), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($debet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($kredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldo)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));


                $no++;
            }
        } else {
            $table->addRow(300, '');
            $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('- N I H I L -'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        };



        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        if ($jumlahDebet == 0) {
            $debet = 0;
        } else {
            $debet = $format->ribuan($jumlahDebet);
        };

        $table->addRow(300, '');
        $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('JUMLAH'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahDebet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahKredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldoAkhir)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
    }

    public function list_bukuTunai($tb_transaksi, $periode, $tahun)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');
        $filterTunai = $this->jenisTunai();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterTunai, '2');
        $saldoAwal = $format->ribuan($vsaldo);

        if ($periode == 1) {
            echo "";
        } else {
            echo " <tr>
            <td align=center width='5px'>-</td>
            <td align=center>--</td>
            <td align=center>--</td>
            <td align=left>Saldo Awal</td>
            <td align=right>$saldoAwal</td>
            <td align=right>0</td>
            <td align=right>$saldoAwal</td>
         </tr>";
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterTunai order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;
        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;

                $tanggal = $format->dateToIndo($data->tanggal);

                if ($data->jenis == 21) {
                    $debet = 0;
                    $kredit = $data->kredit;
                } elseif ($data->jenis == 22) {
                    $debet = $data->debet;
                    $kredit = 0;
                } else {
                    $debet = $data->debet;
                    $kredit = $data->kredit;
                };

                $saldo = ($saldo + $debet - $kredit);


                echo "
                <tr>
                    <td align=center width='5px'>$no</td>
                    <td align=center> $kategori.$data->jenis-$data->bukti</td>
                    <td align=center>$tanggal</td>
                    <td align=left>" . $format->entityEncode($data->uraian) . "</td>
                    <td align=right>" . $format->ribuan($debet) . "</td>
                    <td align=right>" . $format->ribuan($kredit) . "</td>
                    <td align=right>" . $format->ribuan($saldo) . "</td>
                </tr>";
                $no++;
            }
        } else {
            echo  "<tr>
                <td align=center colspan='4'>-- N I H I L --</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>$saldoAwal</td>
            </tr>";
        };;

        //Jumlah Akhir
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo - $setorBank;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0] - $tarikTunai;

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        echo " <tr>
        <td width='5px' colspan='4' align='center'><b>Jumlah</b></td>
        <td align=right><b>" . $format->ribuan($jumlahDebet) . "</b></td>
        <td align=right><b>" . $format->ribuan($jumlahKredit) . "</b></td>
        <td align=right><b>" . $format->ribuan($saldoAkhir) . "</b></td>
     </tr>";
    }
    public function list_bukuTunai_word($tb_transaksi, $periode, $tahun, $table)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');
        $filterTunai = $this->jenisTunai();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterTunai, '2');
        $saldoAwal = $format->ribuan($vsaldo);

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterTunai order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;
        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;

                $tanggal = $format->dateToIndo($data->tanggal);

                if ($data->jenis == 21) {
                    $debet = 0;
                    $kredit = $data->kredit;
                } elseif ($data->jenis == 22) {
                    $debet = $data->debet;
                    $kredit = 0;
                } else {
                    $debet = $data->debet;
                    $kredit = $data->kredit;
                };

                $saldo = ($saldo + $debet - $kredit);

                $table->addRow(300, '');
                $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($no), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($kategori . $data->jenis - $data->bukti), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($tanggal), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($data->uraian), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($debet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($kredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldo)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));


                $no++;
            }
        } else {
            $table->addRow(300, '');
            $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('- N I H I L -'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        };


        //Jumlah Akhir
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo - $setorBank;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterTunai");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0] - $tarikTunai;

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        $table->addRow(300, '');
        $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('JUMLAH'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahDebet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahKredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldoAkhir)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
    }
    public function list_bukuBank($tb_transaksi, $periode, $tahun)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');
        $filterBank = $this->jenisBank();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterBank, '3');
        $saldoAwal = $format->ribuan($vsaldo);
        if ($periode == 1) {
            echo "";
        } else {
            echo " <tr>
            <td align=center width='5px'>-</td>
            <td align=center>--</td>
            <td align=center>--</td>
            <td align=left>Saldo Awal</td>
            <td align=right>$saldoAwal</td>
            <td align=right>0</td>
            <td align=right>$saldoAwal</td>
         </tr>";
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterBank order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;

        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;

                $tanggal = $format->dateToIndo($data->tanggal);

                if ($data->jenis == 22) {
                    $debet = 0;
                    $kredit = $data->kredit;
                } elseif ($data->jenis == 21) {
                    $debet = $data->debet;
                    $kredit = 0;
                } else {
                    $debet = $data->debet;
                    $kredit = $data->kredit;
                };

                $saldo = ($saldo + $debet - $kredit);


                echo "
                <tr>
                    <td align=center width='5px'>$no</td>
                    <td align=center> $kategori.$data->jenis-$data->bukti</td>
                    <td align=center>$tanggal</td>
                    <td align=left>" . $format->entityEncode($data->uraian) . "</td>
                    <td align=right>" . $format->ribuan($debet) . "</td>
                    <td align=right>" . $format->ribuan($kredit) . "</td>
                    <td align=right>" . $format->ribuan($saldo) . "</td>
                </tr>";
                $no++;
            }
        } else {
            echo  "<tr>
                <td align=center colspan='4'>-- N I H I L --</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>$saldoAwal</td>
            </tr>";
        };

        //Jumlah Akhir
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo - $tarikTunai;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0] - $setorBank;

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        echo " <tr>
        <td width='5px' colspan='4' align='center'><b>Jumlah</b></td>
        <td align=right><b>" . $format->ribuan($jumlahDebet) . "</b></td>
        <td align=right><b>" . $format->ribuan($jumlahKredit) . "</b></td>
        <td align=right><b>" . $format->ribuan($saldoAkhir) . "</b></td>
     </tr>";
    }

    public function list_bukuBank_word($tb_transaksi, $periode, $tahun, $table)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');
        $filterBank = $this->jenisBank();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterBank, '3');
        $saldoAwal = $format->ribuan($vsaldo);

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterBank order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;

        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;

                $tanggal = $format->dateToIndo($data->tanggal);

                if ($data->jenis == 22) {
                    $debet = 0;
                    $kredit = $data->kredit;
                } elseif ($data->jenis == 21) {
                    $debet = $data->debet;
                    $kredit = 0;
                } else {
                    $debet = $data->debet;
                    $kredit = $data->kredit;
                };

                $saldo = ($saldo + $debet - $kredit);
                $table->addRow(300, '');
                $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($no), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($kategori . $data->jenis - $data->bukti), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($tanggal), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($data->uraian), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($debet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($kredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldo)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));


                $no++;
            }
        } else {
            $table->addRow(300, '');
            $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('- N I H I L -'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        };

        //Jumlah Akhir
        $tarikTunai = $this->tarikTunai($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBank($periode, $tahun, $tb_transaksi);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo - $tarikTunai;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterBank");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0] - $setorBank;

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        $table->addRow(300, '');
        $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('JUMLAH'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahDebet)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahKredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldoAkhir)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
    }
    public function list_bukuPajak($tb_transaksi, $periode, $tahun)
    {
        $format = new format();

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $filterPajak = $this->jenisPajak();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterPajak, '4');
        $saldoAwal = $format->ribuan($vsaldo);

        //Saldo Per Akun
        $saldoPs21 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411121', $filterPajak);
        $saldoPs22 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411122', $filterPajak);
        $saldoPs23 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411123', $filterPajak);
        $saldoPs4 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411128', $filterPajak);
        $saldoPPN = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411211', $filterPajak);


        if ($periode == 1) {
            echo "";
        } else {
            echo " <tr>
            <td align=center width='5px'>-</td>
            <td align=center>--</td>
            <td align=center>--</td>
            <td align=left>Saldo Awal</td>
            <td align=right>" . $format->ribuan($saldoPs21) . "</td>
            <td align=right>" . $format->ribuan($saldoPs22) . "</td>
            <td align=right>" . $format->ribuan($saldoPs23) . "</td>
            <td align=right>" . $format->ribuan($saldoPs4) . "</td>
            <td align=right>" . $format->ribuan($saldoPPN) . "</td>
            <td align=right>0</td>
            <td align=right>$saldoAwal</td>
         </tr>";
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterPajak order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;
        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $akun = $data->pajak_akun;

                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;

                $saldo = ($saldo + $debet - $kredit);

                $ps21 = $this->vAkunPAjak($akun, '411121', $debet);
                $ps22 = $this->vAkunPAjak($akun, '411122', $debet);
                $ps23 = $this->vAkunPAjak($akun, '411124', $debet);
                $ps4 = $this->vAkunPAjak($akun, '411128', $debet);
                $ppn = $this->vAkunPAjak($akun, '411211', $debet);


                echo "
                <tr>
                    <td align=center width='5px'>$no</td>
                    <td align=center> $kategori.$data->jenis-$data->bukti</td>
                    <td align=center>$tanggal</td>
                    <td align=left>" . $format->entityEncode($data->uraian) . "</td>
                    <td align=right>" . $format->ribuan($ps21) . "</td>
                    <td align=right>" . $format->ribuan($ps22) . "</td>
                    <td align=right>" . $format->ribuan($ps23) . "</td>
                    <td align=right>" . $format->ribuan($ps4) . "</td>
                    <td align=right>" . $format->ribuan($ppn) . "</td>
                    <td align=right>" . $format->ribuan($kredit) . "</td>
                    <td align=right>" . $format->ribuan($saldo) . "</td>
                </tr>";
                $no++;
            }
        } else {
            echo  "<tr>
                <td align=center colspan='4'>-- N I H I L --</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>0</td>
                <td align=right>$saldoAwal</td>
            </tr>";
        };


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        //Jumlah Per Akun
        $jmlPs21 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411121', $filterPajak);
        $jmlPs22 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411122', $filterPajak);
        $jmlPs23 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411123', $filterPajak);
        $jmlPs4 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411128', $filterPajak);
        $jmlPPN = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411211', $filterPajak);

        echo " <tr>
        <td width='5px' colspan='4' align='center'><b>Jumlah</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs21) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs22) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs23) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs4) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPPN) . "</b></td>
        <td align=right><b>" . $format->ribuan($jumlahKredit) . "</b></td>
        <td align=right><b>" . $format->ribuan($saldoAkhir) . "</b></td>
     </tr>";
    }

    public function list_bukuPajak_word($tb_transaksi, $periode, $tahun, $table)
    {

        $format = new format();

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $filterPajak = $this->jenisPajak();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterPajak, '4');
        $saldoAwal = $format->ribuan($vsaldo);

        //Saldo Per Akun
        $saldoPs21 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411121', $filterPajak);
        $saldoPs22 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411122', $filterPajak);
        $saldoPs23 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411123', $filterPajak);
        $saldoPs4 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411128', $filterPajak);
        $saldoPPN = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411211', $filterPajak);


        //if ($periode == 1) {
        //    echo "";
        //} else {
        //    echo " <tr>
        //    <td align=center width='5px'>-</td>
        //    <td align=center>--</td>
        //    <td align=center>--</td>
        //    <td align=left>Saldo Awal</td>
        //    <td align=right>" . $format->ribuan($saldoPs21) . "</td>
        //    <td align=right>" . $format->ribuan($saldoPs22) . "</td>
        //    <td align=right>" . $format->ribuan($saldoPs23) . "</td>
        //    <td align=right>" . $format->ribuan($saldoPs4) . "</td>
        //    <td align=right>" . $format->ribuan($saldoPPN) . "</td>
        //    <td align=right>0</td>
        //    <td align=right>$saldoAwal</td>
        // </tr>";
        //}

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterPajak order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row = $show->rowCount();
        $no = 1;
        $saldo = $vsaldo;
        if ($row != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $akun = $data->pajak_akun;

                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;

                $saldo = ($saldo + $debet - $kredit);

                $ps21 = $this->vAkunPAjak($akun, '411121', $debet);
                $ps22 = $this->vAkunPAjak($akun, '411122', $debet);
                $ps23 = $this->vAkunPAjak($akun, '411124', $debet);
                $ps4 = $this->vAkunPAjak($akun, '411128', $debet);
                $ppn = $this->vAkunPAjak($akun, '411211', $debet);


                $table->addRow(300, '');
                $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($no), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($kategori . $data->jenis - $data->bukti), 'isi', array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($tanggal), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
                $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($data->uraian), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($ps21)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));

                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($ps22)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($ps23)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($ps4)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($ppn)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($kredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
                $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldo)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));


                $no++;
            }
        } else {
            $table->addRow(300, '');
            $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('- N I H I L -'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
            $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
            $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('') . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        };



        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] + $vsaldo;

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and $filterPajak");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $jumlahKredit = $d_kredit[0];

        $saldoAkhir = $jumlahDebet - $jumlahKredit;

        //Jumlah Per Akun
        $jmlPs21 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411121', $filterPajak);
        $jmlPs22 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411122', $filterPajak);
        $jmlPs23 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411123', $filterPajak);
        $jmlPs4 = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411128', $filterPajak);
        $jmlPPN = $this->sumbukuPajak($periode, $tahun, $tb_transaksi, '411211', $filterPajak);

        echo " <tr>
        <td width='5px' colspan='4' align='center'><b>Jumlah</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs21) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs22) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs23) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPs4) . "</b></td>
        <td align=right><b>" . $format->ribuan($jmlPPN) . "</b></td>
        <td align=right><b>" . $format->ribuan($jumlahKredit) . "</b></td>
        <td align=right><b>" . $format->ribuan($saldoAkhir) . "</b></td>
     </tr>";

        $table->addRow(300, '');
        $table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('JUMLAH'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'center', 'spaceAfter' => 0));
        $table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars(''), 'isi',  array('align' => 'left', 'spaceAfter' => 0));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jmlPs21)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jmlPs22)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jmlPs23)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jmlPs4)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jmlPPN)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($jumlahKredit)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
        $table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($saldoAkhir)) . "\n", 'isi', array('align' => 'right', 'spaceAfter' => 0, 'cellMarginRight' => 200));
    }

    public function list_bku_xlsx($sheet1, $style_row, $tb_transaksi, $periode, $tahun)
    {
        $format = new format();

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        if ($periode == 1) {
            echo "";
        } else {
            $sheet1->setCellValue('A8', '-');
            $sheet1->setCellValue('B8', '-');
            $sheet1->setCellValue('C8', '');
            $sheet1->setCellValue('D8', 'Saldo Awal');
            $sheet1->setCellValue('E8', $vsaldo);
            $sheet1->setCellValue('F8', '0');
            $sheet1->setCellValue('G8', $vsaldo);
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row_count = $show->rowCount();
        $no = 1;
        if ($periode == 1) {
            $row = 8;
        } else {
            $row = 9;
        };
        $row_jumlah = $row_count + $row;
        $saldo = $vsaldo;

        if ($row_count != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;
                $saldo = ($saldo + $debet - $kredit);

                $sheet1->setCellValue('A' . $row, $no);
                $sheet1->setCellValue('B' . $row, $kategori . $data->jenis - $data->bukti);
                $sheet1->setCellValue('C' . $row, $tanggal);
                $sheet1->setCellValue('D' . $row, $data->uraian);
                $sheet1->setCellValue('E' . $row, $debet);
                $sheet1->setCellValue('F' . $row, $kredit);
                $sheet1->setCellValue('G' . $row, $saldo);
                $row++;
                $no++;

                //Format Cell
                $this->formatExcel($sheet1, $style_row, $row_jumlah, '1');
            }
        } else {
            $sheet1->setCellValue('A' . $row, '-');
            $sheet1->setCellValue('B' . $row, '-');
            $sheet1->setCellValue('C' . $row, 'NIHIL');
            $sheet1->setCellValue('D' . $row, '0');
            $sheet1->setCellValue('E' . $row, '0');
            $sheet1->setCellValue('F' . $row, '0');
            $sheet1->setCellValue('G' . $row, $vsaldo);
            $this->formatExcel($sheet1, $style_row, $row_jumlah, '1');
        };

        $sheet1->setCellValue('A' . $row_jumlah, 'JUMLAH');
        $sheet1->setCellValue('E' . $row_jumlah, '=SUM(E8:E' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('F' . $row_jumlah, '=SUM(F8:F' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('G' . $row_jumlah, '=(E' . $row_jumlah . '-F' . $row_jumlah . ')');

        $sheet1->mergeCells('A' . $row_jumlah . ':D' . $row_jumlah);
    }

    public function list_bukuTunai_xlsx($sheet1,  $style_row, $tb_transaksi, $periode, $tahun)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $filterTunai = $this->jenisTunai();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterTunai, '2');
        if ($periode == 1) {
            echo "";
        } else {
            $sheet1->setCellValue('A8', '-');
            $sheet1->setCellValue('B8', '-');
            $sheet1->setCellValue('C8', '');
            $sheet1->setCellValue('D8', 'Saldo Awal');
            $sheet1->setCellValue('E8', $vsaldo);
            $sheet1->setCellValue('F8', '0');
            $sheet1->setCellValue('G8', $vsaldo);
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);


        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterTunai order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row_count = $show->rowCount();
        $no = 1;
        if ($periode == 1) {
            $row = 8;
        } else {
            $row = 9;
        };
        $row_jumlah = $row_count + $row;
        $saldo = $vsaldo;

        if ($row_count != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;
                $saldo = ($saldo + $debet - $kredit);

                $sheet1->setCellValue('A' . $row, $no);
                $sheet1->setCellValue('B' . $row, $kategori . $data->jenis - $data->bukti);
                $sheet1->setCellValue('C' . $row, $tanggal);
                $sheet1->setCellValue('D' . $row, $data->uraian);
                $sheet1->setCellValue('E' . $row, $debet);
                $sheet1->setCellValue('F' . $row, $kredit);
                $sheet1->setCellValue('G' . $row, $saldo);
                $row++;
                $no++;
                //Format Cell
                $this->formatExcel($sheet1, $style_row, $row_jumlah, '2');
            }
        } else {
            $sheet1->setCellValue('A' . $row, '-');
            $sheet1->setCellValue('B' . $row, '-');
            $sheet1->setCellValue('C' . $row, 'NIHIL');
            $sheet1->setCellValue('D' . $row, '0');
            $sheet1->setCellValue('E' . $row, '0');
            $sheet1->setCellValue('F' . $row, '0');
            $sheet1->setCellValue('G' . $row, $vsaldo);
            $this->formatExcel($sheet1, $style_row, $row_jumlah, '2');
        };

        $sheet1->setCellValue('A' . $row_jumlah, 'JUMLAH');
        $sheet1->setCellValue('E' . $row_jumlah, '=SUM(E8:E' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('F' . $row_jumlah, '=SUM(F8:F' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('G' . $row_jumlah, '=(E' . $row_jumlah . '-F' . $row_jumlah . ')');

        $sheet1->mergeCells('A' . $row_jumlah . ':D' . $row_jumlah);
    }

    public function list_bukuBank_xlsx($sheet1, $style_row, $tb_transaksi, $periode, $tahun)
    {

        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $filterBank = $this->jenisBank();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterBank, '3');
        if ($periode == 1) {
            echo "";
        } else {
            $sheet1->setCellValue('A8', '-');
            $sheet1->setCellValue('B8', '-');
            $sheet1->setCellValue('C8', '');
            $sheet1->setCellValue('D8', 'Saldo Awal');
            $sheet1->setCellValue('E8', $vsaldo);
            $sheet1->setCellValue('F8', '0');
            $sheet1->setCellValue('G8', $vsaldo);
        }

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);


        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where   $rangePeriode and $filterBank order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row_count = $show->rowCount();
        $no = 1;
        if ($periode == 1) {
            $row = 8;
        } else {
            $row = 9;
        };
        $row_jumlah = $row_count + $row;
        $saldo = $vsaldo;

        if ($row_count != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;
                $saldo = ($saldo + $debet - $kredit);

                $sheet1->setCellValue('A' . $row, $no);
                $sheet1->setCellValue('B' . $row, $kategori . $data->jenis - $data->bukti);
                $sheet1->setCellValue('C' . $row, $tanggal);
                $sheet1->setCellValue('D' . $row, $data->uraian);
                $sheet1->setCellValue('E' . $row, $debet);
                $sheet1->setCellValue('F' . $row, $kredit);
                $sheet1->setCellValue('G' . $row, $saldo);
                $row++;
                $no++;
                //Format Cell
                $this->formatExcel($sheet1, $style_row, $row_jumlah, '3');
            }
        } else {
            $sheet1->setCellValue('A' . $row, '-');
            $sheet1->setCellValue('B' . $row, '-');
            $sheet1->setCellValue('C' . $row, 'NIHIL');
            $sheet1->setCellValue('D' . $row, '0');
            $sheet1->setCellValue('E' . $row, '0');
            $sheet1->setCellValue('F' . $row, '0');
            $sheet1->setCellValue('G' . $row, $vsaldo);

            $this->formatExcel($sheet1, $style_row, $row_jumlah, '3');
        };

        $sheet1->setCellValue('A' . $row_jumlah, 'JUMLAH');
        $sheet1->setCellValue('E' . $row_jumlah, '=SUM(E8:E' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('F' . $row_jumlah, '=SUM(F8:F' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('G' . $row_jumlah, '=(E' . $row_jumlah . '-F' . $row_jumlah . ')');

        $sheet1->mergeCells('A' . $row_jumlah . ':D' . $row_jumlah);
    }

    public function list_bukuPajak_xlsx($sheet1, $style_row, $tb_transaksi, $periode, $tahun)
    {
        $format = new format();
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $filterPajak = $this->jenisPajak();
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and " . $filterPajak, '4');

        //Saldo Per Akun
        $saldoPs21 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411121', $filterPajak);
        $saldoPs22 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411122', $filterPajak);
        $saldoPs23 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411123', $filterPajak);
        $saldoPs4 = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411128', $filterPajak);
        $saldoPPN = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, '411211', $filterPajak);


        if ($periode == 1) {
            echo "";
        } else {
            $sheet1->setCellValue('A8', '-');
            $sheet1->setCellValue('B8', '-');
            $sheet1->setCellValue('C8', '');
            $sheet1->setCellValue('D8', 'Saldo Awal');
            $sheet1->setCellValue('E8', $saldoPs21);
            $sheet1->setCellValue('F8', $saldoPs22);
            $sheet1->setCellValue('G8', $saldoPs23);
            $sheet1->setCellValue('H8', $saldoPs4);
            $sheet1->setCellValue('I8', $saldoPPN);
            $sheet1->setCellValue('J8', '0');
            $sheet1->setCellValue('K8', $vsaldo);
        }
        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi where  $rangePeriode and $filterPajak order by tanggal asc, debet desc, bukti asc, jenis asc, rkas_akun asc, no asc, time asc");
        $row_count = $show->rowCount();
        $no = 1;
        if ($periode == 1) {
            $row = 8;
        } else {
            $row = 9;
        };
        $row_jumlah = $row_count + $row;
        $saldo = $vsaldo;

        if ($row_count != 0) {
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $kategori = $data->kategori;
                $akun = $data->pajak_akun;
                $tanggal = $format->dateToIndo($data->tanggal);
                $debet = $data->debet;
                $kredit = $data->kredit;
                $saldo = ($saldo + $debet - $kredit);

                $ps21 = $this->vAkunPAjak($akun, '411121', $debet);
                $ps22 = $this->vAkunPAjak($akun, '411122', $debet);
                $ps23 = $this->vAkunPAjak($akun, '411124', $debet);
                $ps4 = $this->vAkunPAjak($akun, '411128', $debet);
                $ppn = $this->vAkunPAjak($akun, '411211', $debet);


                $sheet1->setCellValue('A' . $row, $no);
                $sheet1->setCellValue('B' . $row, $kategori . $data->jenis - $data->bukti);
                $sheet1->setCellValue('C' . $row, $tanggal);
                $sheet1->setCellValue('D' . $row, $data->uraian);
                $sheet1->setCellValue('E' . $row, $ps21);
                $sheet1->setCellValue('F' . $row, $ps22);
                $sheet1->setCellValue('G' . $row, $ps23);
                $sheet1->setCellValue('H' . $row, $ps4);
                $sheet1->setCellValue('I' . $row, $ppn);
                $sheet1->setCellValue('J' . $row, $kredit);
                $sheet1->setCellValue('K' . $row, $saldo);
                $row++;
                $no++;
                //Format Cell
                $this->formatExcel($sheet1, $style_row, $row_jumlah, '4');
            }
        } else {
            $sheet1->setCellValue('A' . $row, '-');
            $sheet1->setCellValue('B' . $row, '-');
            $sheet1->setCellValue('C' . $row, 'NIHIL');
            $sheet1->setCellValue('D' . $row, '0');
            $sheet1->setCellValue('E' . $row, '0');
            $sheet1->setCellValue('F' . $row, '0');
            $sheet1->setCellValue('G' . $row, '0');
            $sheet1->setCellValue('H' . $row, '0');
            $sheet1->setCellValue('I' . $row, '0');
            $sheet1->setCellValue('J' . $row, '0');
            $sheet1->setCellValue('K' . $row, $vsaldo);

            //Format Cell
            $this->formatExcel($sheet1, $style_row, $row_jumlah, '4');
        };

        $sheet1->setCellValue('A' . $row_jumlah, 'JUMLAH');
        $sheet1->setCellValue('E' . $row_jumlah, '=SUM(E8:E' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('F' . $row_jumlah, '=SUM(F8:F' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('G' . $row_jumlah, '=SUM(G8:G' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('H' . $row_jumlah, '=SUM(H8:H' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('I' . $row_jumlah, '=SUM(I8:I' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('J' . $row_jumlah, '=SUM(J8:J' . $row_jumlah - 1 . ')');
        $sheet1->setCellValue('K' . $row_jumlah, '=SUM(E' . $row_jumlah . ':I' . $row_jumlah . ')-J' . $row_jumlah);

        $sheet1->mergeCells('A' . $row_jumlah . ':D' . $row_jumlah);
    }

    private function formatExcel($sheet1, $style_row, $row_jumlah, $buku)
    {
        for ($i = 7; $i <= $row_jumlah; $i++) {

            if ($buku == 4) {
                $sheet1->getStyle('A' . $i . ':A' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('B' . $i . ':B' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('C' . $i . ':C' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('D' . $i . ':D' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('E' . $i . ':E' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('F' . $i . ':F' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('G' . $i . ':G' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('H' . $i . ':H' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('I' . $i . ':I' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('J' . $i . ':J' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('K' . $i . ':K' . $i)->applyFromArray($style_row);

                $sheet1->getStyle('A' . $i . ':A' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('B' . $i . ':B' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('C' . $i . ':C' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('D' . $i . ':D' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                $sheet1->getStyle('E' . $i . ':E' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('F' . $i . ':F' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('G' . $i . ':G' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('H' . $i . ':H' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('I' . $i . ':I' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('J' . $i . ':J' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('K' . $i . ':K' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                $sheet1->getStyle('A1:K' . $i)->getFont()->setName('Arial');
                $sheet1->getStyle('A7:K' . $i)->getFont()->setSize(10);
            } else {
                $sheet1->getStyle('A' . $i . ':A' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('B' . $i . ':B' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('C' . $i . ':C' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('D' . $i . ':D' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('E' . $i . ':E' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('F' . $i . ':F' . $i)->applyFromArray($style_row);
                $sheet1->getStyle('G' . $i . ':G' . $i)->applyFromArray($style_row);

                $sheet1->getStyle('A' . $i . ':A' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('B' . $i . ':B' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('C' . $i . ':C' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $sheet1->getStyle('D' . $i . ':D' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                $sheet1->getStyle('E' . $i . ':E' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('F' . $i . ':F' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet1->getStyle('G' . $i . ':G' . $i)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                $sheet1->getStyle('A1:G' . $i)->getFont()->setName('Arial');
                $sheet1->getStyle('A7:G' . $i)->getFont()->setSize(10);
            }
        }
    }

    public function saldoBulanLalu($periode, $tahun, $tb_transaksi, $kondisi, $jenisBuku)
    {
        //  $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        //Jumlah Akhir
        $tarikTunai = $this->tarikTunaiBulanLalu($periode, $tahun, $tb_transaksi);
        $setorBank = $this->setorBankBulanLalu($periode, $tahun, $tb_transaksi);

        $format = new format;
        $tanggal = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-01');


        $db = database::getInstance();

        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal <'$tanggal' {$kondisi}");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $debet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal <'$tanggal' {$kondisi}");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $kredit = $d_kredit[0];

        if ($jenisBuku == 1 || $jenisBuku == 4) {
            $value = $debet - $kredit;
        } elseif ($jenisBuku == 2) {
            $value = $debet - $kredit - $setorBank + $tarikTunai;
        } elseif ($jenisBuku == 3) {
            $value = $debet - $kredit - $tarikTunai  + $setorBank;
        }
        return $value;
    }

    public function saldoBulanIni($periode, $tahun, $tb_transaksi, $kondisi)
    {

        $db = database::getInstance();
        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);
        $tanggal = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-' . $lastDate);


        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal <='$tanggal' {$kondisi}");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $debet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal <='$tanggal' {$kondisi}");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $kredit = $d_kredit[0];

        $value = $debet - $kredit;
        return $value;
    }

    public function tarikTunai($periode, $tahun, $tb_transaksi)
    {

        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where $rangePeriode  and jenis='22'");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $value = $d_debet[0];
        return $value;
    }
    public function setorBank($periode, $tahun, $tb_transaksi)
    {
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');
        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where $rangePeriode and jenis='21'");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $value = $d_debet[0];
        return $value;
    }
    public function tarikTunaiBulanLalu($periode, $tahun, $tb_transaksi)
    {
        $tanggalx = strtotime($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal = date('Y-m-d', $tanggalx);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal <'$tanggal' and jenis='22'");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $value = $d_debet[0];
        return $value;
    }
    public function setorBankBulanLalu($periode, $tahun, $tb_transaksi)
    {
        $tanggalx = strtotime($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal = date('Y-m-d', $tanggalx);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal <'$tanggal' and jenis='21'");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $value = $d_debet[0];
        return $value;
    }
    public function piutangBulanLalu($periode, $tahun, $tb_transaksi)
    {
        $tanggalx = strtotime($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal = date('Y-m-d', $tanggalx);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal <'$tanggal' and (jenis='47' || jenis='48')");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $debet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal <'$tanggal' and (jenis='45' || jenis='46')");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $kredit = $d_kredit[0];

        $value = $kredit - $debet;
        return $value;
    }
    public function hutangBulanLalu($periode, $tahun, $tb_transaksi)
    {
        $tanggalx = strtotime($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal = date('Y-m-d', $tanggalx);

        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal <'$tanggal' and (jenis='41' || jenis='42')");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $debet = $d_debet[0];

        $q_kredit = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal <'$tanggal' and (jenis='43' || jenis='44')");
        $q_kredit->execute();
        $d_kredit = $q_kredit->fetch();
        $kredit = $d_kredit[0];

        $value = $debet - $kredit;
        return $value;
    }
    public function vAkunPajak($field, $akun, $debet)
    {
        if ($field == $akun && $debet > 0) {
            $value = $debet;
        } else {
            $value = 0;
        }
        return $value;
    }

    public function saldoBLbukuPajak($periode, $tahun, $tb_transaksi, $akun, $filterPajak)
    {
        $vsaldo = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, "and pajak_akun='$akun' and " . $filterPajak, '4');
        return $vsaldo;
    }

    public function sumbukuPajak($periode, $tahun, $tb_transaksi, $akun, $filterPajak)
    {
        $saldo = $this->saldoBLbukuPajak($periode, $tahun, $tb_transaksi, $akun, $filterPajak);
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where  $rangePeriode and $filterPajak and pajak_akun='$akun'");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0] +  $saldo;
        return $jumlahDebet;
    }

    public function ValPeriodeBuku($periode, $tahun)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        if ($periode == '' || $periode == 0) {
            $value = $tahun1 . '-07';
        } elseif ($periode == 1) {
            $value  = $tahun1 . '-07';
        } elseif ($periode == 2) {
            $value  = $tahun1 . '-08';
        } elseif ($periode == 3) {
            $value = $tahun1 . '-09';
        } elseif ($periode == 4) {
            $value = $tahun1 . '-10';
        } elseif ($periode == 5) {
            $value = $tahun1 . '-11';
        } elseif ($periode == 6) {
            $value = $tahun1 . '-12';
        } elseif ($periode == 7) {
            $value = $tahun2 . '-01';
        } elseif ($periode == 8) {
            $value = $tahun2 . '-02';
        } elseif ($periode == 9) {
            $value = $tahun2 . '-03';
        } elseif ($periode == 10) {
            $value = $tahun2 . '-04';
        } elseif ($periode == 11) {
            $value = $tahun2 . '-05';
        } elseif ($periode == 12) {
            $value  = $tahun2 . '-06';
        } else {
            $value = $tahun1 . '-07';
        };
        return $value;
    }

    public function Periode($periode, $tahun)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);


        if ($periode == '' || $periode == 0) {
            $value = 'Juli ' .
                $tahun1;
        } elseif ($periode == 1) {
            $value  = 'Juli ' .
                $tahun1;
        } elseif ($periode == 2) {
            $value  = 'Agustus ' .
                $tahun1;
        } elseif ($periode == 3) {
            $value = 'September '
                . $tahun1;
        } elseif ($periode == 4) {
            $value = 'Oktober ' .
                $tahun1;
        } elseif ($periode == 5) {
            $value = 'Nopember ' .
                $tahun1;
        } elseif ($periode == 6) {
            $value = 'Desember ' .
                $tahun1;
        } elseif ($periode == 7) {
            $value = 'Januari ' .
                $tahun2;
        } elseif ($periode == 8) {
            $value = 'Februari ' .
                $tahun2;
        } elseif ($periode == 9) {
            $value = 'Maret ' .
                $tahun2;
        } elseif ($periode == 10) {
            $value = 'April ' .
                $tahun2;
        } elseif ($periode == 11) {
            $value = 'Mei ' .
                $tahun2;
        } elseif ($periode == 12) {
            $value  = 'Juni ' .
                $tahun2;
        };
        return $value;
    }

    /// -----LAPORAN REALISASI ----- ////
    private function tableTr($source, $tittle, $pl, $textcolor, $akun, $uraian, $pagu, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni, $sisaAnggaran, $persen, $bold, $realisasiPenggunaanPendapatan, $linkRincian)
    {
        if ($bold == 'B') {
            $b1 = "<b class='text-$textcolor'>";
            $b2 = "</b>";
        } elseif ($bold == 'I') {
            $b1 = "<i class='text-$textcolor'>";
            $b2 = "</i>";
        } else {
            $b1 = "";
            $b2 = "";
        };
        $format = new format();
        if ($source == 1) {
            echo "
         <tr bgcolor='#FFFFFF' title='$tittle'>
             <td align=left valign='middle' width='100'><span class='pl-$pl text-$textcolor'>$b1$akun$b2</span></td>
             <td align=left valign='middle' ><span class='pl-1 text-$textcolor'>$b1$uraian$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($pagu) . "</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiBulanLalu) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiKembalisdBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($sisaAnggaran) . "$b2</span></td>
             <td align=right valign='middle' width='80'><span class='text-$textcolor'>$b1$persen$b2</span></td>   
         </tr>
         ";
        } elseif ($source == 2) {
            echo "
        <tr bgcolor='#FFFFFF' height='25' title='$tittle'>
            <td align=left valign='middle' width='70'><span class='pl-$pl text-$textcolor'>$b1$akun$b2</span></td>
            <td align=left valign='middle' ><span class='pl-1 text-$textcolor'>$b1$uraian$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($pagu) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiBulanLalu) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($sisaAnggaran) . "$b2</span></td>
            <td align=right valign='middle' width='50'><span class='text-$textcolor'>$b1$persen$b2</span></td>
        </tr>
            ";
        } elseif ($source == 3) {
            echo "
        <tr bgcolor='#FFFFFF' height='25' title='$tittle'>
            <td align=left valign='middle' width='105'><span class='text-$textcolor pl-$pl'>$b1$akun$b2</span></td>
            <td align=left valign='middle' ><span class='text-$textcolor pl-1'>$b1$uraian$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($pagu) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($sisaAnggaran) . "$b2</span></td>
            <td align=right valign='middle' width='80'><span class='text-$textcolor'>$b1$persen$b2</span></td>
            <td align=center valign='middle' width='80'><span class='text-$textcolor'>$b1 $linkRincian $b2</span></td>
        </tr>
        ";
        } elseif ($source == 31) {
            echo "
        <tr bgcolor='#FFFFFF' height='25' title='$tittle'>
            <td align=left valign='middle' width='105'><span class='text-$textcolor pl-$pl'>$b1$akun$b2</span></td>
            <td align=left valign='middle' ><span class='text-$textcolor pl-1'>$b1$uraian$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($pagu) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiKembalisdBulanIni) . "$b2</span></td>
             <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='130'><span class='text-$textcolor'>$b1" . $format->ribuan($sisaAnggaran) . "$b2</span></td>
            <td align=right valign='middle' width='80'><span class='text-$textcolor'>$b1$persen$b2</span></td>
          
        </tr>
        ";
        } elseif ($source == 4) {
            echo "
        <tr bgcolor='#FFFFFF' height='25' title='$tittle'>
            <td align=left valign='middle' width='70'><span class='text-$textcolor pl-$pl'>$b1$akun$b2</span></td>
            <td align=left valign='middle' ><span class='text-$textcolor pl-1'>$b1$uraian$b2</span></td>
            <td align=right valign='middle' width='130'><b class='text-secondary'>$b1" . $format->ribuan($pagu) . "$b2</span></td>        
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($sisaAnggaran) . "$b2</span></td>
            <td align=right valign='middle' width='50'><span class='text-$textcolor'>$b1$persen$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasiPenggunaanPendapatan) . "$b2</span></td>
            <td align=right valign='middle' width='90'><span class='text-$textcolor'>$b1" . $format->ribuan($realisasisdBulanIni - $realisasiKembalisdBulanIni - $realisasiPenggunaanPendapatan) . "$b2</span></td>
            <td align=right valign='middle' width='50'><span class='text-$textcolor'>$b1$persen$b2</span></td>
        </tr>
            ";
        };
    }


    //LIST KATEGORI
    public function list_kategori($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi, $periode, $tb_transaksi, $source)
    {
        $format = new format();
        if ($source == 4) {
            $filerData = "where kategori='A'";
        } else {
            $filerData = "where kategori!='C'";
        };

        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   simakom_ref_kategori  $filerData order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian =  $format->entityEncode($data->uraian);

            //Jumlah
            $jumlah = $classRKAS->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $classRKAS->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $classRKAS->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            //Kembalian
            if ($kategori_kode == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_kategori='A'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_kategori='B'");
            }


            $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kategori_kode, "");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi, $kategori_kode, "");

            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni + $realisasiKembalisdBulanIni;
            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $jumlah);

            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "");
            $kembaliPendapatan = $this->kembaliPenggunaanPendapatan($tahun, $tb_transaksi, "");


            // $this->tableTr($source, '', '1', 'danger', $kategori_kode, $kategori_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni, $sisaAnggaran, $persen, 'B', $realisasiPenggunaanPendapatan - $realisasiKembalisdBulanIni - $kembaliPendapatan, '#');
            $this->tableTr($source, '', '1', 'danger', $kategori_kode, $kategori_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni, $sisaAnggaran, $persen, 'B', $realisasiPenggunaanPendapatan - $kembaliPendapatan, '#');

            $this->list_kegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori_kode, $tb_revisi, $periode, $tahun, $tb_transaksi, $source);
            $no++;
        }
    }

    //LIST KEGIATAN
    public function list_kegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori, $tb_revisi, $periode, $tahun, $tb_transaksi, $source)
    {
        $format = new format();

        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kategori = '{$kategori}' and revisi='$revisi' group by kegiatan order by kegiatan asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kegiatan_kode = $data->kegiatan;
            $kegiatan_uraian = $format->entityEncode($data->uraian);
            $kategori_kode = $data->kategori;
            $kegiatan_id = $data->id;
            $link = new linkpage;
            $linkRincian = " <a " . $link->pageID($data->id, 'laporan/rincian/kegiatan') . " class='badge bg-default  px-1 py-1 d-inline text-primary'> <i class='bi bi-search'></i> Detail</a>";

            //Kode Custome
            $kegiatan_custome =  $classRKAS->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'kegiatan_custome');

            //Jumlah
            $jumlah =  $classRKAS->sum($tb_detail, 'total', "where kategori='$kategori_kode' and kegiatan='$kegiatan_kode' and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Kembalian
            if ($kategori_kode == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_kegiatan='$kegiatan_kode'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_kegiatan='$kegiatan_kode'");
            }

            $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kategori_kode,  "and rkas_kegiatan='$kegiatan_kode'");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi,  $kategori_kode,  "and rkas_kegiatan='$kegiatan_kode'");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni + $realisasiKembalisdBulanIni;

            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $jumlah);

            //Realisasi Penggunaan Pendapatan
            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_kegiatan='$kegiatan_kode'");
            $kembaliPendapatan = $this->kembaliPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_kegiatan='$kegiatan_kode'");


            $this->tableTr($source, '', '2', 'primary', $kegiatan_custome, $kegiatan_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni,  $realisasiKembalisdBulanIni, $sisaAnggaran, $persen, '', $realisasiPenggunaanPendapatan - $kembaliPendapatan, $linkRincian);

            $this->list_komponen($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $kegiatan_kode, $tb_revisi, $periode, $tahun, $tb_transaksi, $source);
            $no++;
        }
    }
    //LIST KOMPONEN
    public function list_komponen($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $tb_revisi, $periode, $tahun, $tb_transaksi, $source)
    {
        $format = new format();
        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE kegiatan = '{$kegiatan}'  and revisi='$revisi' group by komponen  order by komponen asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $komponen_kode = $data->komponen;
            $komponen_uraian = $format->entityEncode($data->uraian);
            $kode_kegiatan = $data->kegiatan;
            $komponen_id = $data->id;
            $link = new linkpage;
            $linkRincian = " <a " . $link->pageID($data->id, 'laporan/rincian/komponen') . " class='badge bg-default  px-1 py-1 d-inline text-info'> <i class='bi bi-search'></i> Detail</a>";

            //Uraian Kegiatan
            $showkegiatan = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kegiatan = '{$kode_kegiatan}'");
            $kegiatan = $showkegiatan->fetch(PDO::FETCH_OBJ);
            $kegiatan_uraian = $kegiatan->uraian;
            $kode_kategori = $kegiatan->kategori;
            $kegiatan = $kegiatan->kegiatan;
            $uraian_kategori =  $classRKAS->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  --   ' . $kode_kegiatan .  ' : ' . $kegiatan_uraian;


            //Jumlah
            $jumlah =  $classRKAS->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$komponen_kode'  and revisi='$revisi' ");
            //  $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Kembalian
            if ($kode_kategori == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_kegiatan='$kegiatan' and rkas_komponen='" . $komponen_kode . "'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_kegiatan='$kegiatan' and rkas_komponen='" . $komponen_kode . "'");
            }


            // $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kode_kategori,  "and rkas_kegiatan='$kegiatan' and rkas_komponen='" . $komponen_kode . "'");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi,  $kode_kategori,  "and rkas_kegiatan='$kegiatan' and rkas_komponen='" . $komponen_kode . "'");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni + $realisasiKembalisdBulanIni;

            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $jumlah);

            //Realisasi Penggunaan Pendapatan
            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'");
            $kembaliPendapatan = $this->kembaliPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'");

            $this->tableTr($source, $title_kegiatan, '4', 'info', $komponen_kode, $komponen_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni, $sisaAnggaran, $persen, '', $realisasiPenggunaanPendapatan - $kembaliPendapatan, $linkRincian);

            $this->list_akun($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kode_kegiatan, $komponen_kode, $tb_revisi, $periode, $tahun, $tb_transaksi, $source);
            $no++;
        }
    }
    //LIST AKUN
    public function list_akun($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $komponen, $tb_revisi, $periode, $tahun, $tb_transaksi, $source)
    {
        $format = new format();
        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE kegiatan = '{$kegiatan}' and komponen='$komponen'  and revisi='$revisi' group by akun  order by akun asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            // $akun_id = $data->id;
            $akun_kode = $data->akun;
            $akun_uraian = $format->entityEncode($data->uraian);
            $kode_kategori = $data->kategori;
            $kode_kegiatan = $data->kegiatan;
            $kode_komponen = $data->komponen;

            //Akun Custome
            $akun_custome = $classRKAS->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'akun_custome');
            $link = new linkpage;
            $linkRincian = " <a " . $link->pageID($data->id, 'laporan/rincian/akun') . " class='badge bg-default  px-1 py-1 d-inline text-secondary'> <i class='bi bi-search'></i> Detail</a>";

            $uraian_kategori = $classRKAS->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $uraian_kegiatan = $classRKAS->uraianRKAS($tb_kegiatan, 'kegiatan', $kode_kegiatan, 'uraian');
            $uraian_komponen = $classRKAS->uraianRKAS($tb_komponen, 'komponen', $kode_komponen, 'uraian');

            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kode_kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $kode_komponen . ' : ' . $uraian_komponen;


            //Jumlah
            $jumlah = $classRKAS->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$kode_komponen' and akun='$akun_kode'  and revisi='$revisi'");
            // $jumlah_format = @(number_format($jumlah, 0, ",", "."));


            //Kembalian
            if ($kode_kategori == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_kegiatan='$kegiatan' and rkas_akun='" . $akun_kode . "' and rkas_komponen='" . $kode_komponen . "'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_kegiatan='$kegiatan' and rkas_akun='" . $akun_kode . "' and rkas_komponen='" . $kode_komponen . "'");
            }

            // $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kode_kategori, "and rkas_kegiatan='$kegiatan' and rkas_akun='" . $akun_kode . "' and rkas_komponen='" . $kode_komponen . "'");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi,  $kode_kategori,  "and rkas_kegiatan='$kegiatan' and rkas_akun='" . $akun_kode . "' and rkas_komponen='" . $kode_komponen . "'");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni + $realisasiKembalisdBulanIni;

            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $jumlah);

            //Realisasi Penggunaan Pendapatan
            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_akun='$akun_kode' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$kode_komponen'");
            $kembaliPendapatan = $this->kembaliPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_akun='$akun_kode' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$kode_komponen'");



            $this->tableTr($source, $title_kegiatan, '5', 'secondary', $akun_custome, $akun_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni,  $sisaAnggaran, $persen, '0', $realisasiPenggunaanPendapatan - $kembaliPendapatan, $linkRincian);

            $this->list_detail($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi, $periode, $tahun, $tb_transaksi, $source);
            $no++;
        }
    }
    //LIST DETAIL
    public function list_detail($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi, $periode, $tahun, $tb_transaksi, $source)
    {
        $format = new format();
        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_detail WHERE  kategori='{$kode_kategori}' and kegiatan='{$kode_kegiatan}' and komponen='$kode_komponen' and akun = '{$akun_kode}' and revisi='$revisi' order by detail asc, time asc");
        $no = 1;
        $row = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun = $data->akun;
            $id_detail = $data->id;
            $rkas_id_detail = $data->detail_id;
            $detail_uraian = $format->entityEncode($data->uraian);

            //Akun Custome
            $akun_custome = $classRKAS->kodeCustome('simakom_ref_akun', 'akun', $akun, 'akun_custome');
            $link = new linkpage;
            $linkRincian = " <a " . $link->pageID($data->id, 'laporan/rincian/detail') . " class='badge bg-default  px-1 py-1 d-inline text-secondary'> <i class='bi bi-search'></i> Detail</a>";
            $akun_uraian = $format->entityEncode($data->uraian);
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;

            //$kategori = $data->kategori;
            // $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $detail = $data->detail;
            $detail_id = $data->detail_id;
            $uraian = $format->entityEncode($data->uraian);
            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;

            $viewPerh = $classRKAS->viewPerhitungan($komponen_1, $komponen_2, $komponen_3, $komponen_4, $unit_1, $unit_2, $unit_3, $unit_4);
            $uraian_detail = $detail_uraian . ' ' . $viewPerh;

            // $total = number_format($data->total, 0, ",", ".");

            $uraian_kategori = $classRKAS->uraianRKAS('simakom_ref_kategori', 'kategori', $kategori, 'uraian');
            $uraian_kegiatan = $classRKAS->uraianRKAS($tb_kegiatan, 'kegiatan', $kegiatan, 'uraian');

            $uraian_komponen = $classRKAS->uraianRKAS($tb_komponen, 'kode_id', $kategori . $kegiatan . $komponen, 'uraian');

            $uraian_akun = $classRKAS->uraianRKAS($tb_akun, 'akun', $akun, 'uraian');
            $title_akun = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $komponen . ' : ' . $uraian_komponen . ' - ' . $akun_custome . ' : ' . $uraian_akun;


            $rowdetail = $akun_custome . '.' . $detail;




            //Realisasi Penggunaan Pendapatan
            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, " and pembiayaan_id='" . $rkas_id_detail . "'");
            $kembaliPendapatan = $this->kembaliPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_id='" . $rkas_id_detail . "'");


            //Kembalian
            if ($kategori == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_detail_id='" . $rkas_id_detail . "'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_detail_id='" . $rkas_id_detail . "'");
            }

            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kategori,  " and rkas_kegiatan='$kegiatan' and rkas_detail_id='$rkas_id_detail'");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi,  $kategori,  " and rkas_kegiatan='$kegiatan' and rkas_detail_id='$rkas_id_detail'");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $data->total - $realisasisdBulanIni + $realisasiKembalisdBulanIni;
            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $data->total);


            $this->tableTr($source, $title_akun, '', 'secondary', '', $rowdetail . '-' . $uraian_detail, $data->total, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni, $sisaAnggaran, $persen,  'I', $realisasiPenggunaanPendapatan - $kembaliPendapatan, $linkRincian);

            $no++;
        }
    }

    //Laporan per Akun
    public function list_reportAkun($tahun, $tb_kegiatan,  $tb_komponen, $tb_akun, $tb_detail, $tb_revisi, $periode, $tb_transaksi, $source)
    {
        if ($source == 4) {
            $filerData = "where kategori='A'";
        } else {
            $filerData = "where kategori!='C'";
        };
        $format = new format();
        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   simakom_ref_kategori  $filerData order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian = $format->entityEncode($data->uraian);

            //Jumlah
            $jumlah = $classRKAS->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $classRKAS->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $classRKAS->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            //Kembalian
            if ($kategori_kode == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') ");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') ");
            }
            $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kategori_kode, "");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi, $kategori_kode, "");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni;
            $persen = $this->persenRealisasi($realisasisdBulanIni, $jumlah);

            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_kegiatan!=''");



            $this->tableTr($source, '', '1', 'danger', $kategori_kode, $kategori_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni,  $sisaAnggaran, $persen, 'B', $realisasiPenggunaanPendapatan, '#');

            $this->list_akun_report($kategori_kode, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi, $periode, $tahun, $tb_transaksi, $source);
            $no++;
        }
    }
    public function list_akun_report($kategori, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $tb_revisi, $periode, $tahun, $tb_transaksi, $source)
    {
        $format = new format();
        $classRKAS = new simakom_rkas();
        $revisi = $classRKAS->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE kategori='$kategori' and revisi='$revisi' group by akun  order by akun asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            // $akun_id = $data->id;
            $akun_kode = $data->akun;
            $akun_uraian = $format->entityEncode($data->uraian);
            $kode_kategori = $data->kategori;
            $kode_kegiatan = $data->kegiatan;
            $kode_komponen = $data->komponen;

            //Akun Custome
            $akun_custome = $classRKAS->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'akun_custome');
            $link = new linkpage;
            $linkRincian = " <a " . $link->pageID($data->id, 'laporan/rincian/akun') . " class='badge bg-default  px-1 py-1 d-inline text-secondary'> <i class='bi bi-search'></i> Detail</a>";

            $uraian_kategori = $classRKAS->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $uraian_kegiatan = $classRKAS->uraianRKAS($tb_kegiatan, 'kegiatan', $kode_kegiatan, 'uraian');
            $uraian_komponen = $classRKAS->uraianRKAS($tb_komponen, 'komponen', $kode_komponen, 'uraian');

            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kode_kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $kode_komponen . ' : ' . $uraian_komponen;


            //Jumlah
            $jumlah = $classRKAS->sum($tb_detail, 'total', "where kategori='$kode_kategori' and akun='$akun_kode'  and revisi='$revisi'");
            // $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Kembalian
            if ($kode_kategori == 'A') {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'kredit', "and (jenis='35' || jenis='36') and rkas_akun='$akun_kode'");
            } else {
                $realisasiKembalisdBulanIni = $this->realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, 'debet', "and (jenis='15' || jenis='16') and rkas_akun='$akun_kode'");
            }

            // $format = new format();
            $realisasiBulanLalu = $this->realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kode_kategori, "and rkas_akun='" . $akun_kode . "'");
            $realisasiBulanIni = $this->realisasiDetailBulanIni($periode, $tahun, $tb_transaksi,  $kode_kategori,  "and rkas_akun='" . $akun_kode . "'");
            $realisasisdBulanIni = $realisasiBulanLalu + $realisasiBulanIni;
            $sisaAnggaran =  $jumlah - $realisasisdBulanIni + $realisasiKembalisdBulanIni;

            $persen = $this->persenRealisasi($realisasisdBulanIni - $realisasiKembalisdBulanIni, $jumlah);

            //Realisasi Penggunaan Pendapatan
            $realisasiPenggunaanPendapatan = $this->realisasiPenggunaanPendapatan($tahun, $tb_transaksi, "and pembiayaan_akun='$akun_kode'");



            $this->tableTr($source, $title_kegiatan, '5', 'secondary', $akun_custome, $akun_uraian, $jumlah, $realisasiBulanLalu, $realisasiBulanIni, $realisasisdBulanIni, $realisasiKembalisdBulanIni,  $sisaAnggaran, $persen, '0', $realisasiPenggunaanPendapatan, $linkRincian);
            $no++;
        }
    }
    public function realisasiDetailBulanLalu($periode, $tahun, $tb_transaksi, $kategori, $kondisi)
    {
        $tanggalx = strtotime($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal1 = date('Y-m-d', $tanggalx);


        if ($kategori == "A") {
            $fieldSUM = "debet";
        } else {
            $fieldSUM = "kredit";
        };

        //Jml Pengembalian Pendapatan
        $jmlPengembalianPendaatan = $this->realisasiPengembalian($tb_transaksi, 'kredit', "where tanggal<'$tanggal1' and (jenis='35' || jenis='36') {$kondisi}");
        $jmlPengembalianBelanja = $this->realisasiPengembalian($tb_transaksi, 'debet', "where tanggal<'$tanggal1' and (jenis='15' || jenis='16') {$kondisi}");


        $db = database::getInstance();
        $q_value = $db->runQuery("SELECT SUM({$fieldSUM}) FROM {$tb_transaksi} where  tanggal<'$tanggal1' and rkas_kategori='$kategori' {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        // $value = $d_value[0] - $jmlPengembalianBelanja - $jmlPengembalianPendaatan;
        $value = $d_value[0];

        return $value;
    }

    public function realisasiDetailBulanIni($periode, $tahun, $tb_transaksi, $kategori, $kondisi)
    {

        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);

        $tanggal1 = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-01');
        $tanggal2 = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-' . $lastDate);



        if ($kategori == "A") {
            $fieldSUM = "debet";
        } else {
            $fieldSUM = "kredit";
        };

        //Jml Pengembalian Pendapatan
        $jmlPengembalianPendaatan = $this->realisasiPengembalian($tb_transaksi, 'kredit', "where tanggal >='$tanggal1' and tanggal <='$tanggal2' and (jenis='35' || jenis='36') {$kondisi}");
        $jmlPengembalianBelanja = $this->realisasiPengembalian($tb_transaksi, 'debet', "where tanggal >='$tanggal1' and tanggal <='$tanggal2' and (jenis='15' || jenis='16') {$kondisi}");

        $db = database::getInstance();
        $q_value = $db->runQuery("SELECT SUM({$fieldSUM}) FROM {$tb_transaksi} where tanggal >='$tanggal1' and tanggal <='$tanggal2' and rkas_kategori='$kategori' {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        // $value = $d_value[0] - $jmlPengembalianBelanja - $jmlPengembalianPendaatan;
        $value = $d_value[0];

        return $value;
    }

    //Pengembalian
    public function realisasiPengembalian($tb_transaksi, $kolom, $kondisi)
    {


        $db = database::getInstance();
        $q_value = $db->runQuery("SELECT SUM({$kolom}) FROM {$tb_transaksi} {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        $value = $d_value[0];
        return $value;
    }
    public function realisasiPengembalianBulanIni($periode, $tahun, $tb_transaksi, $kolom, $kondisi)
    {
        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);
        $tanggal2 = $format->stringTotDate($this->ValPeriodeBuku($periode, $tahun) . '-' . $lastDate);

        $db = database::getInstance();
        //$q_value = $db->runQuery("SELECT SUM({$kolom}) FROM {$tb_transaksi} where tanggal >='$tanggal1' and tanggal <='$tanggal2' {$kondisi}");
        $q_value = $db->runQuery("SELECT SUM({$kolom}) FROM {$tb_transaksi} where tanggal <='$tanggal2' {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        $value = $d_value[0];
        return $value;
    }

    public function realisasiPenggunaanPendapatan($tahun, $tb_transaksi, $kondisi)
    {
        $db = database::getInstance();
        //Penggunaan
        $q_value = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where rkas_kategori='B' {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        $value = $d_value[0];
        return $value;
    }

    public function kembaliPenggunaanPendapatan($tahun, $tb_transaksi, $kondisi)
    {
        $db = database::getInstance();
        //Penggunaan
        $q_value = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where rkas_kategori='B' {$kondisi}");
        $q_value->execute();
        $d_value = $q_value->fetch();
        $value = $d_value[0];
        return $value;
    }

    private function persenRealisasi($realisasi, $anggaran)
    {
        if ($realisasi == 0 || $anggaran == 0) {
            $persen = number_format(0, 2, ",", ".");
        } else {
            $persen = number_format(($realisasi / $anggaran) * 100, 2, ",", ".");
        }
        return $persen;
    }

    public function RealisasiHariIni($tb_transaksi, $kategori)
    {
        $time = new time;
        $today = $time->getDate();

        if ($kategori == "A") {
            $field = "debet";
        } else {
            $field = "kredit";
        };
        $db = database::getInstance();
        $q_value = $db->runQuery("SELECT SUM({$field}) FROM {$tb_transaksi} where rkas_kategori='{$kategori}' and tanggal='$today'");
        $q_value->execute();
        $d_value = $q_value->fetch();
        $value = $d_value[0];
        return $value;
    }

    //LPJ BENDAHARA & BAP KAS
    public function insertLPJ($tb_lpj)
    {
        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;
        $format = new format;

        $periode = $cekIssetPost->cek('periode');
        $tahun = $cekIssetPost->cek('tahun');
        $tanggal = $format->dateToEng($cekIssetPost->cekDate('tanggal'));

        $id = substr(md5($periode), 0, 5) . substr(md5($tahun), 5, 5) . substr(md5($tanggal), 5, 10) . substr(md5($periode . $tahun . $tanggal), 5, 10);

        if (isset($_POST['submitLPJ']) and $tanggal != "") {
            $crud = new crudData();
            $array = [
                'tanggal' => $tanggal,
                'periode' => $periode,
                'tahun' => $tahun,
                'tunai_awal' => 0,
                'tunai_debet' => 0,
                'tunai_kredit' => 0,
                'tunai_akhir' => 0,
                'bank_awal' => 0,
                'bank_debet' => 0,
                'bank_kredit' => 0,
                'bank_akhir' => 0,
                'bku_awal' => 0,
                'bku_debet' => 0,
                'bku_kredit' => 0,
                'bku_akhir' => 0,
                'bank_riil' => 0,
                'tunai_riil' => 0,
                'bank_selisih' => 0,
                'tunai_selisih' => 0,
                'selisihtunai_keterangan1' => '',
                'selisihtunai_keterangan2' => '',
                'selisihbank_keterangan1' => '',
                'selisihbank_keterangan2' => '',
                'rekening_nama1' => '',
                'rekening_jumlah1' => 0,
                'rekening_nama2' => '',
                'rekening_jumlah2' => 0,
                'rekening_nama3' => '',
                'rekening_jumlah3' => 0,
                'pecahan_100' => 0,
                'pecahan_75' => 0,
                'pecahan_50' => 0,
                'pecahan_20' => 0,
                'pecahan_10' => 0,
                'pecahan_5' => 0,
                'pecahan_2' => 0,
                'pecahan_1' => 0,
                'pecahan_05' => 0,
                'pecahan_02' => 0,
                'pecahan_01' => 0,
                'pecahan_005' => 0,
                'catatan' => '',
                'id' => $id

            ];
            $save = $crud->insertData($tb_lpj, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'laporan/lpj/index');
        } else {
            echo "";
        };
    }
    public function insertRekamLPJ($tb_lpj, $idLPJ)
    {
        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;
        $format = new format;

        //$periode = $cekIssetPost->cek('periode');
        // $tahun = $cekIssetPost->cek('tahun');
        // $tanggal = $format->dateToEng($cekIssetPost->cekDate('tanggal'));
        $tanggal = $format->dateToEng($cekIssetPost->cekDate('tanggal'));
        $bku_awal = $cekIssetPost->cekNumber('bku_awal');
        $bku_debet = $cekIssetPost->cekNumber('bku_debet');
        $bku_kredit = $cekIssetPost->cekNumber('bku_kredit');
        $bku_akhir = $cekIssetPost->cekNumber('bku_akhir');
        $tunai_awal = $cekIssetPost->cekNumber('tunai_awal');
        $tunai_debet = $cekIssetPost->cekNumber('tunai_debet');
        $tunai_kredit = $cekIssetPost->cekNumber('tunai_kredit');
        $tunai_akhir = $cekIssetPost->cekNumber('tunai_akhir');
        $bank_awal = $cekIssetPost->cekNumber('bank_awal');
        $bank_debet = $cekIssetPost->cekNumber('bank_debet');
        $bank_kredit = $cekIssetPost->cekNumber('bank_kredit');
        $bank_akhir = $cekIssetPost->cekNumber('bank_akhir');

        $tunai_riil = $cekIssetPost->cekNumber('tunai_riil');

        $selisihtunai_keterangan1 = $cekIssetPost->cek('selisihtunai_keterangan1');
        $selisihtunai_keterangan2 = $cekIssetPost->cek('selisihtunai_keterangan2');
        $selisihbank_keterangan1 = $cekIssetPost->cek('selisihbank_keterangan1');
        $selisihbank_keterangan2 = $cekIssetPost->cek('selisihbank_keterangan2');
        $rekening_nama1 = $cekIssetPost->cek('rekening_nama1');
        $rekening_jumlah1 = $cekIssetPost->cekNumber('rekening_jumlah1');
        $rekening_nama2 = $cekIssetPost->cek('rekening_nama2');
        $rekening_jumlah2 = $cekIssetPost->cekNumber('rekening_jumlah2');
        $rekening_nama3 = $cekIssetPost->cek('rekening_nama3');
        $rekening_jumlah3 = $cekIssetPost->cekNumber('rekening_jumlah3');

        $pecahan_100 = $cekIssetPost->cekNumber('pecahan_100');
        $pecahan_75 = $cekIssetPost->cekNumber('pecahan_75');
        $pecahan_50 = $cekIssetPost->cekNumber('pecahan_50');
        $pecahan_20 = $cekIssetPost->cekNumber('pecahan_20');
        $pecahan_10 = $cekIssetPost->cekNumber('pecahan_10');
        $pecahan_5 = $cekIssetPost->cekNumber('pecahan_5');
        $pecahan_2 = $cekIssetPost->cekNumber('pecahan_2');
        $pecahan_1 = $cekIssetPost->cekNumber('pecahan_1');
        $pecahan_05 = $cekIssetPost->cekNumber('pecahan_05');
        $pecahan_02 = $cekIssetPost->cekNumber('pecahan_02');
        $pecahan_01 = $cekIssetPost->cekNumber('pecahan_01');
        $pecahan_005 = $cekIssetPost->cekNumber('pecahan_005');
        $catatan = $cekIssetPost->cek('catatan');

        $bank_riil = $rekening_jumlah1 + $rekening_jumlah2 + $rekening_jumlah3;;
        $tunai_riil = $this->lpj_uangriil($pecahan_100, $pecahan_75, $pecahan_50, $pecahan_20, $pecahan_10, $pecahan_5, $pecahan_2, $pecahan_1, $pecahan_05, $pecahan_02, $pecahan_01, $pecahan_005);

        $bank_selisih =  $bank_riil - $bank_akhir;
        $tunai_selisih =  $tunai_riil - $tunai_akhir;


        if (isset($_POST['submitLPJ'])) {
            $crud = new crudData();
            $array = [
                'tanggal' => $tanggal,
                'bku_awal' => $bku_awal,
                'bku_debet' => $bku_debet,
                'bku_kredit' => $bku_kredit,
                'bku_akhir' => $bku_akhir,
                'tunai_awal' => $tunai_awal,
                'tunai_debet' => $tunai_debet,
                'tunai_kredit' => $tunai_kredit,
                'tunai_akhir' => $tunai_akhir,
                'bank_awal' => $bank_awal,
                'bank_debet' => $bank_debet,
                'bank_kredit' => $bank_kredit,
                'bank_akhir' => $bank_akhir,
                'bank_riil' => $bank_riil,
                'tunai_riil' => $tunai_riil,
                'bank_selisih' => $bank_selisih,
                'tunai_selisih' => $tunai_selisih,
                'selisihtunai_keterangan1' => $selisihtunai_keterangan1,
                'selisihtunai_keterangan2' => $selisihtunai_keterangan2,
                'selisihbank_keterangan1' => $selisihbank_keterangan1,
                'selisihbank_keterangan2' => $selisihbank_keterangan2,
                'rekening_nama1' => $rekening_nama1,
                'rekening_jumlah1' => $rekening_jumlah1,
                'rekening_nama2' => $rekening_nama2,
                'rekening_jumlah2' => $rekening_jumlah2,
                'rekening_nama3' => $rekening_nama3,
                'rekening_jumlah3' => $rekening_jumlah3,
                'pecahan_100' => $pecahan_100,
                'pecahan_75' => $pecahan_75,
                'pecahan_50' => $pecahan_50,
                'pecahan_20' => $pecahan_20,
                'pecahan_10' => $pecahan_10,
                'pecahan_5' => $pecahan_5,
                'pecahan_2' => $pecahan_2,
                'pecahan_1' => $pecahan_1,
                'pecahan_05' => $pecahan_05,
                'pecahan_02' => $pecahan_02,
                'pecahan_01' => $pecahan_01,
                'pecahan_005' => $pecahan_005,
                'catatan' => $catatan,
                'id' => $idLPJ

            ];
            // $save = $crud->insertData($tb_lpj, $array);
            $update = $crud->updateData($tb_lpj, $array, ['id', ' = ', $idLPJ]);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'laporan/lpj/index');
        } else {
            echo "";
        };
    }
    public function periodelpj($periode, $tahun)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        if ($periode == '' || $periode == 0) {
            $value = 'Juli ' .
                $tahun1;
        } elseif ($periode == 1) {
            $value  = 'Juli ' .
                $tahun1;
        } elseif ($periode == 2) {
            $value  = 'Agustus ' .
                $tahun1;
        } elseif ($periode == 3) {
            $value = 'September '
                . $tahun1;
        } elseif ($periode == 4) {
            $value = 'Oktober ' .
                $tahun1;
        } elseif ($periode == 5) {
            $value = 'November ' .
                $tahun1;
        } elseif ($periode == 6) {
            $value = 'Desember ' .
                $tahun1;
        } elseif ($periode == 7) {
            $value = 'Januari ' .
                $tahun2;
        } elseif ($periode == 8) {
            $value = 'Februari ' .
                $tahun2;
        } elseif ($periode == 9) {
            $value = 'Maret ' .
                $tahun2;
        } elseif ($periode == 10) {
            $value = 'April ' .
                $tahun2;
        } elseif ($periode == 11) {
            $value = 'Mei ' .
                $tahun2;
        } elseif ($periode == 12) {
            $value  = 'Juni ' .
                $tahun2;
        };
        return $value;
    }
    public function ValPeriodeLPJ($periode, $tahun)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        if ($periode == '' || $periode == 0) {
            $value = $tahun1 . '-07';
        } elseif ($periode == 1) {
            $value  = $tahun1 . '-07';
        } elseif ($periode == 2) {
            $value  = $tahun1 . '-08';
        } elseif ($periode == 3) {
            $value = $tahun1 . '-09';
        } elseif ($periode == 4) {
            $value = $tahun1 . '-10';
        } elseif ($periode == 5) {
            $value = $tahun1 . '-11';
        } elseif ($periode == 6) {
            $value = $tahun1 . '-12';
        } elseif ($periode == 7) {
            $value = $tahun2 . '-01';
        } elseif ($periode == 8) {
            $value = $tahun2 . '-02';
        } elseif ($periode == 9) {
            $value = $tahun2 . '-03';
        } elseif ($periode == 10) {
            $value = $tahun2 . '-04';
        } elseif ($periode == 11) {
            $value = $tahun2 . '-05';
        } elseif ($periode == 12) {
            $value  = $tahun2 . '-06';
        } else {
            $value = $tahun1 . '-07';
        };
        return $value;
    }

    public function lpj_debet($periode, $tahun, $tb_transaksi, $filterbuku)
    {
        // $vsaldobku = $this->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);
        $tanggal1 = $format->stringTotDate($this->ValPeriodeLPJ($periode, $tahun) . '-01');
        $tanggal2 = $format->stringTotDate($this->ValPeriodeLPJ($periode, $tahun) . '-' . $lastDate);


        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(debet) FROM {$tb_transaksi} where tanggal >='$tanggal1' and tanggal <='$tanggal2' $filterbuku");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];
        return $jumlahDebet;
    }
    public function lpj_kredit($periode, $tahun, $tb_transaksi, $filterbuku)
    {
        $format = new format;
        $lastDate = $format->lastDateOfPeriode($periode, $tahun);
        $tanggal1 = $format->stringTotDate($this->ValPeriodeLPJ($periode, $tahun) . '-01');
        $tanggal2 = $format->stringTotDate($this->ValPeriodeLPJ($periode, $tahun) . '-' . $lastDate);
        $db = database::getInstance();
        $q_debet = $db->runQuery("SELECT SUM(kredit) FROM {$tb_transaksi} where tanggal >='$tanggal1' and tanggal <='$tanggal2' $filterbuku");
        $q_debet->execute();
        $d_debet = $q_debet->fetch();
        $jumlahDebet = $d_debet[0];
        return $jumlahDebet;
    }
    public function lpj_uangriil($p100000, $p75000, $p50000, $p20000, $p10000, $p5000, $p2000, $p1000, $p500, $p200, $p100, $p50)
    {
        $p100000 = $p100000 * 100000;
        $p75000 = $p75000 * 75000;
        $p50000 = $p50000 * 50000;
        $p20000 = $p20000 * 20000;
        $p10000 = $p10000 * 10000;
        $p5000 = $p5000 * 5000;
        $p2000 = $p2000 * 2000;
        $p1000 = $p1000 * 1000;
        $p500 = $p500 * 500;
        $p200 = $p200 * 200;
        $p100 = $p100 * 100;
        $p50 = $p50 * 50;
        $jumlah = $p100000 + $p75000 + $p50000 + $p20000 + $p10000 + $p5000 + $p2000 + $p1000 + $p500 + $p200 + $p100 + $p50;
        return $jumlah;
    }
    public function penjelasan_selisih($tunai1, $tunai2, $tunai3, $bank1, $bank2, $bank3)
    {
        if (strlen($tunai1 > 3)) {
            $tunai1 = $tunai1;
        } else {
            $tunai1 = "";
        };
        if (strlen($tunai2 > 3)) {
            $tunai2 = $tunai2;
        } else {
            $tunai2 = "";
        };
        if (strlen($tunai3 > 3)) {
            $tunai1 = $tunai3;
        } else {
            $tunai3 = "";
        };

        if (strlen($bank1 > 3)) {
            $bank1 = $bank1;
        } else {
            $bank1 = "";
        };
        if (strlen($bank2 > 3)) {
            $bank2 = $bank2;
        } else {
            $bank2 = "";
        };
        if (strlen($bank3 > 3)) {
            $bank1 = $bank3;
        } else {
            $bank3 = "";
        };
        //$deskripsi=

        // return $jumlah;
    }
}
