<?php

require_once "../../../../../../asset/mod/autoLoad.php";
require_once "../../../../layout/conn.php";
require_once "../../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$linkpost = new linkpost;
$format = new format;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;


$query = "SELECT * FROM $tb_siswa WHERE nama LIKE :search || nis LIKE :search LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_siswa WHERE nama LIKE :search OR nis LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);
$no = 0;
$rows = '';
foreach ($datas as $data) {

    $id = $data->id;

    $nis = $data->nis;


    $no++;
    $num = $no + $offset;

    $rows .= "<tr>";
    $rows .= "<td width='5px'>$num</td>";
    $rows .= "<td>" . $linkpost->IDSiswa($id, 'laporan/siswa/print_preview', $id, $tahun, '', 'search', 'primary') . "</td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->jenjang . "-" . $data->paralel . "</td>";
    $rows .= "<td><a " . $link->pageIDReportSiswa($id, 'seting/siswa/buku_preview', $nis, $tahun) . " class='badge badge-secondary  px-1 py-1 d-inline''> <i class='bi bi-printer'></i> BUKU PEMBAYARAN</a></td>";
    $rows .= "</tr>";
}


$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
