<?php
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);

$sekolah = new sekolah;
$link = new linkpage;

if (isset($_POST['jenis']) && $_POST['jenis'] != 'Semua') {
    $jenis_lap = $_POST['jenis'];
} else {
    $jenis_lap = "Semua";
};
if (isset($_POST['jenjang']) && $_POST['jenjang'] != 'Semua') {
    $jenjang_lap = $_POST['jenjang'];
    $jenjang_post = $_POST['jenjang'];
    $aktifjenis = "";
} else {
    $jenjang_lap = "--Pilih--";
    $jenjang_post = "Semua";
    $aktifjenis = "disabled";
};
if (isset($_POST['paralel']) && $_POST['paralel'] != 'Semua') {
    $paralel_lap = $_POST['paralel'];
} else {
    $paralel_lap = "Semua";
};
if (isset($_POST['kategori']) && $_POST['kategori'] != 'Semua') {
    $kategori_lap = $_POST['kategori'];
} else {
    $kategori_lap = "Semua";
};
if (isset($_POST['status']) && $_POST['status'] != 'Semua') {
    $status_lap = $_POST['status'];
} else {
    $status_lap = "Semua";
};

$dt_jenis = new namaBayar();
$showJenis = $dt_jenis->shownamaBayar($tahun, $jenis_lap, $jenjang_lap);
$count_nb = $showJenis->rowCount();
$datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
if ($count_nb > 0) {
    $namaBayar = $datajenis->nama;
} else {
    $namaBayar = "Semua";
};



//Query Tanggungan
$classTanggungan = new listTanggungan();
$val_sumtang = $classTanggungan->sumTanggunganByFilterRekap($tb_siswa, $jenjang_post, $paralel_lap, $status_lap, $jenis_lap);

if ($val_sumtang == "" || $val_sumtang  == 0 || isset($_POST['jenjang']) == NULL) {
    $sumtanggungan = number_format(0, 0, ",", ".");
    $v_sumtanggungan = 0;
} else {
    $sumtanggungan = number_format($val_sumtang, 0, ",", ".");
    $v_sumtanggungan = $val_sumtang;
};
//Terbayar & Kurang
if (isset($_POST['jenjang']) == NULL) {
    $terbayar = @(number_format(0, 0, ".", "."));
    $kurang = @(number_format(0, 0, ".", "."));;
} else {
    $classTrans = new transaksi();
    $Terbayar = $classTrans->sumTerbayar($tb_transaksi, $jenjang_post, $paralel_lap, $jenis_lap);
    $terbayar = @(number_format($Terbayar, 0, ".", "."));
    $kurang = $v_sumtanggungan - $Terbayar;
    $kurang = @(number_format(($kurang), 0, ".", "."));
};






//Indo to Egg
function ubahformatTgl($tanggal)
{
    $pisah = explode('-', $tanggal);
    $urutan = array($pisah[2], $pisah[1], $pisah[0]);
    $satukan = implode('-', $urutan);
    return $satukan;
}

?>

<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary  py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-journal-text"></span> Laporan Rekapitulasi Model-4 </b>
                        </div>
                        <div class="card-body mb-0">
                            <div class="row mx-3 mt-2" style="background-color: '';">
                                <div class="col-md-6">
                                    <div class="card-body mt-4 px-1 mx-2">
                                        <form action="" method="post">

                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Kelas [Jenjang-Paralel]</label>
                                                <div class="col-md-2">
                                                    <select name="jenjang" class="form-control form-control-sm fontInput small" onchange="this.form.submit()">

                                                        <option><?php echo $jenjang_lap; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        $jenjang = strtolower($sekolah->dataSekolah('jenjang'));

                                                        $opt = new form();
                                                        $opval = $opt->optSelect('tb_tingkat', "where {$jenjang}<>'' order by no asc");
                                                        while ($dataopt = $opval->fetch(PDO::FETCH_OBJ)) {
                                                            $optJenjang = $dataopt->{$jenjang};
                                                            echo "<option>" . $optJenjang . " </option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-7">
                                                    <select name="paralel" class="form-control form-control-sm fontInput small" required>
                                                        <option><?php echo $paralel_lap; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        $opval = $opt->optSelect('tb_paralel', ' order by paralel asc');
                                                        while ($datapar = $opval->fetch(PDO::FETCH_OBJ)) {
                                                            echo "<option>$datapar->paralel</option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Kategori Siswa</label>
                                                <div class="col-md-9">
                                                    <select name="kategori" class="form-control form-control-sm fontInput small" required>
                                                        <option><?php echo $kategori_lap; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        $opval = $opt->optSelect('tb_siswa_kategori', ' order by kategori asc');
                                                        while ($datapar = $opval->fetch(PDO::FETCH_OBJ)) {
                                                            echo "<option>$datapar->kategori</option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Status Aktif Siswa</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-control-sm fontInput small" required>
                                                        <option value="<?php echo $status_lap; ?>"><?php if ($status_lap == "Aktif") {
                                                                                                        echo "Aktif";
                                                                                                    } elseif ($status_lap == "Tidak") {
                                                                                                        echo "Non Aktif";
                                                                                                    } else {
                                                                                                        echo "Semua";
                                                                                                    }; ?></option>
                                                        <option>Semua</option>
                                                        <option value="Aktif">Aktif</option>
                                                        <option value="Tidak">Non Aktif</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <label class="col-sm-3 col-form-label">Jenis Pembayaran</label>
                                                <div class="col-md-9">
                                                    <select name="jenis" class="form-control form-control-sm fontInput small" disabled>
                                                        <option value="<?php echo $jenis_lap; ?>"><?php echo $jenis_lap . " : " . $namaBayar; ?></option>
                                                        <option>Semua</option>
                                                        <?php
                                                        // $dt_jenis = new namaBayar();
                                                        $showJenis = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $jenjang_lap, 'kode');
                                                        $count = $showJenis->rowCount();
                                                        while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
                                                            echo "<option value='$datajenis->kode'>$datajenis->kode : $datajenis->nama</option>";
                                                        };
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row mt-3">
                                                <label class="col-sm-3 col-form-label"></label>
                                                <div class="col-md-9">
                                                    <button type="submit" class="btn btn-primary btn-xs float-right px-2 mx-1" name="save"><i class="bi-funnel"></i> <b>FILTER</b></button>
                                        </form>

                                        <?php echo $link->exportXlsxLapRekap1('laporan/rekapitulasi/print_excel_4', $tahun,  $jenjang_post, $paralel_lap, $kategori_lap, $jenis_lap, $status_lap); ?>

                                        <form name="cetak" action="<?php echo $link->pageAction('laporan/rekapitulasi/print_preview'); ?>" method="post">
                                            <input name="model" value="4" hidden>
                                            <input name="tahun" value="<?php echo $tahun; ?>" hidden>
                                            <input name="jenis" value="<?php echo $jenis_lap; ?>" hidden>
                                            <input name="jenjang" value="<?php echo $jenjang_post; ?>" hidden>
                                            <input name="paralel" value="<?php echo $paralel_lap; ?>" hidden>
                                            <input name="kategori" value="<?php echo $kategori_lap; ?>" hidden>
                                            <input name="status" value="<?php echo $status_lap; ?>" hidden>
                                            <button type="submit" class="btn btn-primary btn-xs float-right px-2 mx-1 d-inline"><i class="bi bi-printer"></i><b> CETAK</b></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card-body mt-4 px-1 mx-2">
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <div class="info-box mb-3">
                                            <span class="info-box-icon bg-primary elevation-1"><i class="bi bi-journal-text"></i></span>
                                            <div class="info-box-content">

                                                <div class="col-sm-12 invoice-col">
                                                    <dl class="row">

                                                        <dt class="col-sm-4 pt-3">JML TANGGUNGAN</dt>
                                                        <dd class="col-sm-8 pt-3"><b>: <?php echo $sumtanggungan; ?></b></dd>
                                                        <dt class="col-sm-4">JML TERBAYAR</dt>
                                                        <dd class="col-sm-8 "><b>: <?php echo $terbayar; ?> </b></dd>
                                                        <dt class="col-sm-4">JML KURANG</dt>
                                                        <dd class="col-sm-8"><b>: <?php echo $kurang; ?></b>
                                                        </dd>
                                                    </dl>
                                                </div>



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>


                <div class="card-body mx-4">
                    <label>
                        <h6><b class="text-primary">REKAPITULASI</b></h6>
                    </label>
                    <table id="example51" class="table table-bordered table-striped table-hover table-sm mb-4">
                        <thead>
                            <tr>
                                <th width="5">No</th>
                                <th width="100">Nama</th>
                                <th width="10">NIS</th>
                                <th width="10">Kelas</th>
                                <th width="300">Detail</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php
                            $classLaporan = new laporan();
                            $showList = $classLaporan->showRekap($tb_siswa, $jenjang_lap, $paralel_lap, $kategori_lap, $status_lap, 'jenjang asc, paralel asc, nama asc');
                            $no = 1;
                            while ($data = $showList->fetch(PDO::FETCH_OBJ)) {

                                $nis = $data->nis;
                                $id = $data->id;
                                $nama = $data->nama;
                                $jenjang = $data->jenjang;
                                $paralel = $data->paralel;
                                $kelas = $jenjang . '-' . $paralel;

                                //Jumlah
                                $dt_jenis = new listTanggungan();
                                $jumlah = $dt_jenis->tanggunganSiswa($tb_siswa, 'id', $id);
                                $total_tang = number_format($jumlah, 0, ".", ".");

                                //Terbayar & Kurang Total
                                $infoTerbayartotal = $classTrans->infoterbayartotal($tb_transaksi, $nis);
                                $terbayarTotal = @(number_format($infoTerbayartotal, 0, ".", "."));
                                $kurangTotal = @(number_format(($jumlah - $infoTerbayartotal), 0, ".", "."));

                                echo "
                                    <tr>
                                        <td width='5px'>$no</td>
                                        <td align=left>$nama</td>
                                        <td align=left>$nis</td>
                                        <td align=left>$kelas</td>
                                        <td width='50px' align='left'>";

                                echo "<table id='example51' class='table table-bordered table-striped table-hover table-sm mb-4'>
                                                    <tr>
                                                        <th>No</th>
                                                        <th>Nama</th>
                                                        <th>Tanggungan</th>
                                                        <th>Tahap-1</th>
                                                        <th>Tahap-2</th>
                                                        <th>Tahap-3</th>
                                                        <th>Tahap-4</th>
                                                        <th>Tahap-5</th>
                                                        <th>Tahap-6</th>
                                                        <th>Tahap-7</th>
                                                        <th>Tahap-8</th>
                                                        <th>Tahap-9</th>
                                                        <th>Tahap-10</th>
                                                        <th>Tahap-11</th>
                                                        <th>Tahap-12</th>
                                                        <th>Jumlah</th>
                                                        <th>Kurang</th>
                        
                                                    </tr>
                                                    ";
                                //RINCIAN 
                                $dt_jenis = new namaBayar();
                                $showJenis = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $jenjang, 'kode');
                                $count_nb = $showJenis->rowCount();
                                $no_jenis = 0;
                                while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
                                    $field_tang = 'tang_' . $datajenis->kode;
                                    $namaBayar =  $datajenis->nama;
                                    $kode =  $datajenis->kode;

                                    if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
                                        $val_tang = 0;
                                    } else {
                                        $val_tang = $data->{$field_tang};
                                    }; //Cek jika jumlah tanggungan kosong / bukan angka

                                    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

                                    $rupiah_tang = @(number_format($val_tang, 0, ".", "."));
                                    $jenis = $datajenis->kode;

                                    //Terbayar & Kurang
                                    $classTrans = new transaksi();
                                    $infoTerbayar = $classTrans->infoterbayar($tb_transaksi, $nis, $jenis);
                                    $terbayar = @(number_format($infoTerbayar, 0, ".", "."));
                                    $kurang = @(number_format(($val_tang - $infoTerbayar), 0, ".", "."));

                                    if ($setbulanan == "Ya" || $setbulanan == "ya") {
                                        $bulanan = @(number_format(($val_tang / (12 - ($startAt - 1))), 0, ".", "."));
                                        $disabledQty = "";
                                    } else {
                                        $bulanan = "--";
                                        $disabledQty = "disabled";
                                    };

                                    if ($count_nb > 0) {
                                        $namaBayar = $datajenis->nama;
                                        $bulanan = $datajenis->bulanan;
                                        $filterJenis = "and jenis='$datajenis->kode'";
                                    } else {
                                        $namaBayar = "Semua";
                                        $bulanan = "Tidak";
                                        $filterJenis = "";
                                    };

                                    if ($bulanan == "Ya" or $bulanan == "ya") {
                                        $tahap1 = "Juli";
                                        $tahap2 = "Agt";
                                        $tahap3 = "Sept";
                                        $tahap4 = "Okt";
                                        $tahap5 = "Nop";
                                        $tahap6 = "Des";
                                        $tahap7 = "Jan";
                                        $tahap8 = "Feb";
                                        $tahap9 = "Mar";
                                        $tahap10 = "Apr";
                                        $tahap11 = "Mei";
                                        $tahap12 = "Jun";
                                    } else {
                                        $tahap1 = "Thp-1";
                                        $tahap2 = "Thp-2";
                                        $tahap3 = "Thp-3";
                                        $tahap4 = "Thp-4";
                                        $tahap5 = "Thp-5";
                                        $tahap6 = "Thp-6";
                                        $tahap7 = "Thp-7";
                                        $tahap8 = "Thp-8";
                                        $tahap9 = "Thp-9";
                                        $tahap10 = "Thp-10";
                                        $tahap11 = "Thp-11";
                                        $tahap12 = ">=12";
                                    };

                                    $no_jenis++;
                                    echo "  <tr>
                                                <td>" . $no_jenis . "</td>
                                                <td>" . $kode . " : " . $namaBayar . "</td>
                                                <td align=right>" . $rupiah_tang . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=1", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=2", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=3", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=4", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=5", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=6", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=7", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=8", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=9", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=10", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap=11", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $classLaporan->sumTahap($tb_transaksi, "tahap>=12", $nis,  $filterJenis) . "</td>
                                                <td align=right>" . $terbayar . "</td>
                                                <td align=right>" . $kurang . "</td>
                                            </tr>";
                                };
                                echo "  <tr>
                                            <td colspan='2' align='center'><b>JUMLAH</b></td>
                                            <td align=right><b>" . $total_tang . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=1", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=2", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=3", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=4", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=5", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=6", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=7", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=8", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=9", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=10", $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap=11",  $nis) . "</b></td>
                                            <td align=right><b>" . $classLaporan->totalTahapModel4($tb_transaksi, "tahap>=12", $nis) . "</b></td>
                                            <td align=right><b>" . $terbayarTotal . "</b></td>
                                            <td align=right><b>" . $kurangTotal . "</b></td>
                                        </tr>";
                                echo "</table>";
                                echo "</td>
                                    </tr>";
                                $no++;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>