<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class importExcel  extends database
{
    public function select($query, $paramType = "", $paramArray = array())
    {
        // $stmt = $this->conn->prepare($query);
        $db = database::getInstance();
        if (!empty($paramType) && !empty($paramArray)) {

            $this->bindQueryParams($db, $paramType, $paramArray);
        }
        $db->execute();
        $result = $db->get_result();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $resultset[] = $row;
            }
        }

        if (!empty($resultset)) {
            return $resultset;
        }
    }

    /**
     * To insert
     *
     * @param string $query
     * @param string $paramType
     * @param array $paramArray
     * @return int
     */
    public function insert($query, $paramType, $paramArray)
    {
        // $stmt = $this->conn->prepare($query);
        $db = database::getInstance();
        $this->bindQueryParams($db, $paramType, $paramArray);

        $db->execute();
        $insertId = $db->insert_id;
        return $insertId;
    }

    /**
     * To execute query
     *
     * @param string $query
     * @param string $paramType
     * @param array $paramArray
     */
    public function execute($query, $paramType = "", $paramArray = array())
    {
        // $stmt = $this->conn->prepare($query);
        $db = database::getInstance();
        if (!empty($paramType) && !empty($paramArray)) {
            $this->bindQueryParams($db, $paramType, $paramArray);
        }
        $db->execute();
    }

    /**
     * 1.
     * Prepares parameter binding
     * 2. Bind prameters to the sql statement
     *
     * @param string $stmt
     * @param string $paramType
     * @param array $paramArray
     */
    public function bindQueryParams($stmt, $paramType, $paramArray = array())
    {
        $paramValueReference[] = &$paramType;
        for ($i = 0; $i < count($paramArray); $i++) {
            $paramValueReference[] = &$paramArray[$i];
        }
        call_user_func_array(array(
            $stmt,
            'bind_param'
        ), $paramValueReference);
    }

    /**
     * To get database results
     *
     * @param string $query
     * @param string $paramType
     * @param array $paramArray
     * @return array
     */
    public function getRecordCount($query, $paramType = "", $paramArray = array())
    {
        // $stmt = $this->conn->prepare($query);
        $db = database::getInstance();

        if (!empty($paramType) && !empty($paramArray)) {

            $this->bindQueryParams($db, $paramType, $paramArray);
        }
        $db->execute();
        $db->store_result();
        $recordCount = $db->num_rows;

        return $recordCount;
    }
}
