<?php
$format = new format;
$clsLaporan = new tabungan_laporan;
$totalSaldoAWal = $clsLaporan->rekapTotalSaldoAwal($tabungan_siswa, '');
$totalDebet = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'D', '');
$totalKredit = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'K', '');
$totalSaldoAkhir = @((int)$totalSaldoAWal + (int)$totalDebet - (int)$totalKredit);

?>

<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-bar-chart-line"></span> Laporan Rekapitulasi</b>
                        </div>
                        <div class="row col-md-12">

                            <div class="col-md-12">
                                <div class="card-body mt-4 px-1 mx-2">

                                    <div class="row">
                                        <div class="col-12 col-sm-12 col-md-12">
                                            <div class="info-box mb-3">
                                                <div class="info-box-content">
                                                    <div class="relative mb-0 pb-4">
                                                        <input name="judul" value="REKAPITULASI" style="background-color: gainsboro;" class="form-control-sm col-sm-2 fontInput small bg-default mt-3 text-center" disabled>
                                                    </div>

                                                    <div class="col-sm-12 invoice-col">

                                                        <div class="col-md-12">
                                                            <div class="card-body mt-4 px-1 mx-2">
                                                                <div class="row">
                                                                    <div class="col-12 col-sm-6 col-md-12">
                                                                        <div class="info-box mb-3">
                                                                            <span class="info-box-icon bg-primary elevation-1"><i class="bi bi-bar-chart-line"></i></span>
                                                                            <div class="info-box-content">
                                                                                <div class="col-sm-12 invoice-col">
                                                                                    <dl class="row">
                                                                                        <dt class="col-sm-4 pt-3">SALDO AWAL</dt>
                                                                                        <dd class="col-sm-8 pt-3"><b>: <?php echo $format->ribuan($totalSaldoAWal); ?></b></dd>
                                                                                        <dt class="col-sm-4">SETORAN</dt>
                                                                                        <dd class="col-sm-8 "><b>: <?php echo $format->ribuan($totalDebet);
                                                                                                                    ?></b></dd>
                                                                                        <dt class="col-sm-4">PENARIKAN</dt>
                                                                                        <dd class="col-sm-8 "><b>: <?php echo $format->ribuan($totalKredit);
                                                                                                                    ?> </b></dd>
                                                                                        <dt class="col-sm-4">SALDO AKHIR</dt>
                                                                                        <dd class="col-sm-8"><b>: <?php echo $format->ribuan($totalSaldoAkhir);
                                                                                                                    ?></b>
                                                                                        </dd>
                                                                                    </dl>
                                                                                    <div class="div d-inline">

                                                                                        <form name="cetak" action="<?php echo $link->pageAction('laporan/rekapitulasi/print_preview'); ?>" method="post">
                                                                                            <input name="tahun" value="<?php echo $tahun; ?>" hidden>
                                                                                            <button type="submit" class="btn btn-primary btn-xs float-left px-2 mx-1 d-inline"><i class="bi bi-printer"></i> CETAK</button>
                                                                                        </form>
                                                                                        <?php echo $link->exportXlsx('laporan/rekapitulasi/laporan_export', $tahun); ?>
                                                                                    </div>
                                                                                </div>

                                                                            </div>

                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <div class="card-body mx-2">
                                                            <label>
                                                                <h6><b class="text-primary">RINCIAN NASABAH</b></h6>
                                                            </label>
                                                            <table id="example3" class="table table-bordered table-striped table-hover table-sm  mb-4">
                                                                <thead>
                                                                    <tr>
                                                                        <th width="15">No</th>
                                                                        <th>NIS</th>
                                                                        <th>Nama Nasabah</th>
                                                                        <th width="15">L/P</th>
                                                                        <th>Kelas</th>
                                                                        <th width="100">Saldo Awal</th>
                                                                        <th width="100">Debet</th>
                                                                        <th width="100">Kredit</th>
                                                                        <th width="100">Saldo Akhir</th>
                                                                        <th>Status</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>

                                                                    <?php
                                                                    $clsCrud = new crudData();
                                                                    $show = $clsCrud->showTable($tabungan_siswa . " order by status asc, nama asc");
                                                                    $no = 0;
                                                                    while ($data = $show->fetch(PDO::FETCH_OBJ)) {

                                                                        $nis = $data->nis;
                                                                        $clsCrud = new crudData;

                                                                        //count tabel siswa
                                                                        $count = $clsCrud->countData($tb_siswa, " where nis='$nis'");
                                                                        if ($count > 0) {
                                                                            $kelas = $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'jenjang') . "-" . $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'paralel');
                                                                        } else {
                                                                            $kelas = "--";
                                                                        };

                                                                        $clsTabungan = new tabungan;
                                                                        $jmlDebet = $clsTabungan->sumByID($tabungan_transaksi, 'D', 'nis', $data->nis);
                                                                        $jmlKredit = $clsTabungan->sumByID($tabungan_transaksi, 'K', 'nis', $data->nis);

                                                                        $saldoAkhir = @($data->saldo) + $jmlDebet - $jmlKredit;

                                                                        $link = new linkpage;
                                                                        $format = new format;
                                                                        $no++;
                                                                        echo "
                                                                        <tr>
                                                                            <td align='center'>$no</td>
                                                                            <td align='center'>$data->nis</td>
                                                                            <td>$data->nama</td>
                                                                            <td align='center'>$data->kelamin</td>
                                                                            <td align='center'>$kelas</td>
                                                                            <td align='right'>" . $format->ribuan($data->saldo) . "</td>
                                                                            <td align='right'>" . $format->ribuan($jmlDebet) . "</td>
                                                                            <td align='right'>" . $format->ribuan($jmlKredit) . "</td>
                                                                            <td align='right'>" . $format->ribuan($saldoAkhir) . "</td>
                                                                            <td>$data->status</td>
                                                                           
                                                                        </tr>";
                                                                    };

                                                                    ?>

                                                                </tbody>
                                                            </table>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>