<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;

$query = "SELECT * FROM $tabungan_siswa WHERE nama LIKE :search || nis LIKE :search || rekening LIKE :search  LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tabungan_siswa WHERE nama LIKE :search || nis LIKE :search || rekening LIKE :search ");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {

    $nis = $data->nis;
    $clsCrud = new crudData;

    //count tabel siswa
    $count = $clsCrud->countData($tb_siswa, " where nis='$nis'");
    if ($count > 0) {
        $kelas = $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'jenjang') . "-" . $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'paralel');
    } else {
        $kelas = "--";
    };

    $clsTabungan = new tabungan;
    $jmlDebet = $clsTabungan->SUMdebetKredit($tabungan_transaksi, 'D', " and nis='$data->nis'");
    $jmlKredit = $clsTabungan->SUMdebetKredit($tabungan_transaksi, 'K', " and nis='$data->nis'");

    $saldoAkhir = @($data->saldo) + $jmlDebet - $jmlKredit;

    $link = new linkpage;
    $linkpost = new linkpost;
    $format = new format;


    $rows .= "<tr>";
    $rows .= "<td width='5px'><input type='checkbox' name='selectRow' class='delete-checkbox d-inline small' value='{$data->id}'></td>";
    $rows .= "<td><a " . $link->pageID($data->id, 'nasabah/nasabah_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a></td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->rekening . "</td>";
    $rows .= "<td>" . $kelas . "</td>";
    $rows .= "<td>" . $format->ribuan($data->saldo) . "</td>";
    $rows .= "<td>" . $format->ribuan($jmlDebet) . "</td>";
    $rows .= " <td>" . $format->ribuan($jmlKredit) . "</td>";
    $rows .= " <td>" . $format->ribuan($saldoAkhir) . "</td>";
    $rows .= "<td>" . $data->status . "</td>";

    $rows .= "<td> <a " . $link->pageID($data->id, 'transaksi/transaksi_read') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-book'></i> TRANSAKSI</a></td>";
    $rows .= "<td><a " . $link->pageIDReportSiswa($data->id, 'nasabah/buku_preview', $data->nis, $tahun) . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-printer'></i> BUKU TABUNGAN</a></td>";
    $rows .= "</tr>";
}


$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
