<!DOCTYPE html>
<html lang="en">

<head>

    <link rel="stylesheet" href="../../../../../asset/bootstrap/css/adminlte.min.css">

    <style>
        .font {
            font-family: arial;
            font-size: 11px;
        }

        .fontlamp {
            font-family: arial;
            font-size: 8px;
        }

        .fontJudullamp {
            font-size: 12px;
            font-family: arial;

        }

        .fontInput {
            font-size: 11px;
            font-family: arial;
        }

        .fontJudul {
            font-size: 12px;
            font-family: arial;
            color: dodgerblue;
            background: #000;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed small">

    <div class="wrapper">
        <?php
        require('../../../../../asset/mod/autoLoad.php');


        date_default_timezone_set('Asia/Jakarta');
        $tanggal = mktime(date("m"), date("d"), date("Y"));
        $tglsekarang = date("d-m-Y", $tanggal);
        $tahunnow = date("Y", $tanggal);

        if (isset($_POST['tahun'])) {
            $tahun = $_POST['tahun'];
        } elseif (isset($_GET['tahun'])) {
            $tahun = $_GET['tahun'];
        } else {
            $tahun = $tahunnow;
        };

        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        $tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

        $tb_siswa = "tb_siswa" . $tahun_tabel;
        $tb_transaksi = "db_transaksi" . $tahun_tabel;
        $tb_detailakun = "detail_akun" . $tahun_tabel;
        $tb_setor = "setor_kjks" .  $tahun_tabel;
        $tb_transaksisim = "sim_transaksi" . $tahun_tabel;

        if (isset($_GET['nis'])) {
            $nis = $_GET['nis'];
            $id = $_GET['id'];
        } else {
            $nis = 0;
        };

        //Indo to Egg
        function ubahformatTgl($tanggal)
        {
            $pisah = explode('-', $tanggal);
            $urutan = array($pisah[2], $pisah[1], $pisah[0]);
            $satukan = implode('-', $urutan);
            return $satukan;
        }


        $class = new crudData();
        $showData = $class->editData($tb_siswa, 'id', $id);
        $data = $showData->fetch(PDO::FETCH_OBJ);
        $jenjang_siswa = $data->jenjang;
        $paralel_siswa = $data->paralel;

        $clsLaporan = new laporan;
        $walikelas = $clsLaporan->walikelas($jenjang_siswa, $paralel_siswa);


        ?>


        <div class="container col-12 mb-4">
            <div class="row">
                <div class="col-12">
                    <div class="row">


                        <div class="card-body col-12 mx-4">
                            <h5 class="page-header">
                                <?php
                                $view = new lembaga;
                                $clssekolah = new sekolah;
                                echo $view->viewImage('../../../../../asset/dokumen/foto/', 'logo', 'mr-2 position-absolute', '60', '60');
                                echo "<b class='d-block ml-5 pl-3 pt-1'>" . $clssekolah->dataSekolah('sekolah') . "</b>";
                                echo "<i class='footer font ml-5 pl-3 mb-2 pb-3'>" . $clssekolah->dataSekolah('alamat') . "</i>"; ?>
                                <small class="float-right position-relative"><b class="text-danger">LAPORAN SISWA <br>TP. <?php echo $tahun; ?></b> </small><br>
                            </h5>
                        </div>

                        <div class="card-body mx-4">
                            <dl class="row">
                                <dt class="col-sm-3">Nomor Induk Siswa (NIS)</dt>
                                <dd class="col-sm-3"><?php echo $data->nis; ?></dd>
                                <dt class="col-sm-3">Nama Siswa</dt>
                                <dd class="col-sm-3"><?php echo $data->nama; ?></dd>
                                <dt class="col-sm-3">Kelas</dt>
                                <dd class="col-sm-3"><?php echo $data->jenjang . '-' . $data->paralel; ?></dd>
                                <dt class="col-sm-3">Jenis Kelamin</dt>
                                <dd class="col-sm-3"><?php echo $data->kelamin; ?></dd>
                                <dt class="col-sm-3">No Telpon</dt>
                                <dd class="col-sm-3"><?php echo $data->hp; ?></dd>
                                <dt class="col-sm-3">Email</dt>
                                <dd class="col-sm-3"><?php echo $data->email; ?></dd>
                                <dt class="col-sm-3">Orang Tua/wali</dt>
                                <dd class="col-sm-3"><?php echo $data->ortu; ?></dd>
                                <dt class="col-sm-3">Alamat</dt>
                                <dd class="col-sm-3"><?php echo $data->alamat; ?></dd>
                                <dt class="col-sm-3">Kategori</dt>
                                <dd class="col-sm-3"><?php echo $data->kategori; ?></dd>
                                <dt class="col-sm-3">Status</dt>
                                <dd class="col-sm-3"><?php echo $data->status; ?></dd>
                                <dt class="col-sm-3">Mulai Pembayaran</dt>
                                <dd class="col-sm-3"><?php $optVal = new Lembaga();
                                                        $val = $optVal->ValPeriode($data->startAt, $tahun1, $tahun2);
                                                        echo $val; ?></dd>
                                <dt class="col-sm-3">Wali Kelas</dt>
                                <dd class="col-sm-3"><?php echo $walikelas; ?></dd>

                            </dl>
                        </div>



                        <div class="card-body mx-4">
                            <label>
                                <h6><b class="text-primary">REKAPITULASI TRANSAKSI</b></h6>
                            </label>
                            <table class="table table-bordered table-sm small">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Kode : Jenis Pembayaran</th>
                                        <th>Bulanan</th>
                                        <th>Tanggungan</th>
                                        <th>Terbayar</th>
                                        <th>Kurang</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $dt_jenis = new namaBayar();
                                    $showJenis = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $data->jenjang, 'kode');
                                    $count = $showJenis->rowCount();
                                    while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
                                        $field_tang = 'tang_' . $datajenis->kode;

                                        if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
                                            $val_tang = 0;
                                        } else {
                                            $val_tang = $data->{$field_tang};
                                        }; //Cek jika jumlah tanggungan kosong / bukan angka

                                        $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

                                        $rupiah_tang = @(number_format($val_tang, 0, ".", "."));
                                        $jenis = $datajenis->kode;

                                        //Terbayar & Kurang
                                        $classTrans = new transaksi();
                                        $infoTerbayar = $classTrans->infoterbayar($tb_transaksi, $data->nis, $jenis);
                                        $terbayar = @(number_format($infoTerbayar, 0, ".", "."));
                                        $kurang = @(number_format(($val_tang - $infoTerbayar), 0, ".", "."));

                                        if ($setbulanan == "Ya" || $setbulanan == "ya") {
                                            $bulanan = @(number_format(($val_tang / (12 - ($startAt - 1))), 0, ".", "."));
                                        } else {
                                            $bulanan = "--";
                                        };

                                        echo "<tr>
                                            <td width='5px'>#</td>
                                            <td align=left>$datajenis->kode : $datajenis->nama</td>
                                            <td align=right>$bulanan</td>
                                            <td align=right>$rupiah_tang</td>
                                            <td align=right>$terbayar</td>
                                            <td align=right>$kurang</td>
                                           
                                        </tr>";
                                    };
                                    //Jumlah
                                    $dt_jenis = new listTanggungan();
                                    $jumlah = $dt_jenis->tanggunganSiswa($tb_siswa, 'id', $id);
                                    $total_tang = number_format($jumlah, 0, ".", ".");

                                    //Terbayar & Kurang Total
                                    $infoTerbayartotal = $classTrans->infoterbayartotal($tb_transaksi, $data->nis);
                                    $terbayarTotal = @(number_format($infoTerbayartotal, 0, ".", "."));
                                    $kurangTotal = @(number_format(($jumlah - $infoTerbayartotal), 0, ".", "."));
                                    echo "<tr>
                                            <td width='5px'>#</td>
                                            <td align=left colspan='2'><b>TOTAL</b></td>
                                            <td align=right><b> $total_tang</b></td>
                                            <td align=right><b> $terbayarTotal</b></td>
                                            <td align=right><b> $kurangTotal</b></td>
                                           
                                        </tr>";

                                    ?>

                                </tbody>
                            </table>



                        </div>
                        <!-- /.card-header -->
                        <div class="card-body mx-4">
                            <label>
                                <h6><b class="text-primary">RINCIAN TRANSAKSI</b></h6>
                            </label>

                            <table id="" class="table table-bordered table-striped table-sm small">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Tanggal</th>

                                        <th>Kode : Jenis Pembayaran</th>
                                        <th>Periode</th>
                                        <th>Jumlah</th>
                                        <th>Metode</th>
                                        <th>Penerima</th>
                                        <th>Keterangan</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php

                                    $class = new transaksi();
                                    $showList = $class->showTransaksiSiswa($tb_transaksi, $data->nis);
                                    $no = 0;
                                    while ($dataTr = $showList->fetch(PDO::FETCH_OBJ)) {
                                        if ($dataTr->jumlah == "" || $dataTr->jumlah == 0) {
                                            $jumlah = number_format(0, 0, ",", ".");
                                        } else {
                                            $jumlah = number_format($dataTr->jumlah, 0, ",", ".");
                                        };

                                        $tahap = $dataTr->tahap;

                                        //startAt
                                        $startAt = $class->startAt($tb_siswa, $data->nis);
                                        $cekbulan = $class->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

                                        //nama Bayar
                                        $classNB = new namaBayar();
                                        $ceknamaBayar = $classNB->ceknamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);

                                        $showJenis = $classNB->shownamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);
                                        $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
                                        $field_tang = 'tang_' . $datajenis->kode;
                                        $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

                                        if ($setbulanan == "Tidak") {
                                            $periode = "Tahap " . $tahap;
                                        } else {
                                            $periode = $cekbulan;
                                        };
                                        $no++;
                                        echo "
                                                    <tr>
                                                        <td width='5px'>$no
                                                        </td>
                                                        <td align=left>$dataTr->time</td>
                                                      
                                                        <td align=left>$dataTr->jenis : $ceknamaBayar</td>
                                                        <td align=left>$periode</td>
                                                        <td align=left>" . $jumlah . "</td>
                                                        <td align=left>$dataTr->metode</td>
                                                        <td align=left>$dataTr->penerima</td>
                                                        <td align=left>$dataTr->catatan</td>
                                                       
                                                    </tr>";
                                    }

                                    ?>

                                </tbody>
                            </table>



                        </div>
                    </div>
                </div>
            </div>

            </section>

        </div>


        <script src="../../../../bootstrap/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="../../../../bootstrap/plugins/sweetalert2/sweetalert2.min.js"></script>
        <script src="../../../../bootstrap/plugins/toastr/toastr.min.js"></script>
        <script src="../../../../bootstrap/js/adminlte.min.js"></script>
        <script src="../../../../bootstrap/plugins/jquery-ui/jquery-ui.min.js"></script>
        <script src="../../../../bootstrap/plugins/chart.js/Chart.min.js"></script>
        <script src="../../../../bootstrap/plugins/sparklines/sparkline.js"></script>
        <script src="../../../../bootstrap/plugins/jqvmap/jquery.vmap.min.js"></script>
        <script src="../../../../bootstrap/plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
        <script src="../../../../bootstrap/plugins/jquery-knob/jquery.knob.min.js"></script>
        <script src="../../../../bootstrap/plugins/moment/moment.min.js"></script>
        <script src="../../../../bootstrap/plugins/daterangepicker/daterangepicker.js"></script>
        <script src="../../../../bootstrap/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
        <script src="../../../../bootstrap/plugins/summernote/summernote-bs4.min.js"></script>
        <script src="../../../../bootstrap/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
        <script src="../../../../bootstrap/js/pages/dashboard.js"></script>
        <script src="../../../../bootstrap/plugins/select2/js/select2.full.min.js"></script>
        <script src="../../../../bootstrap/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
        <script src="../../../../bootstrap/plugins/inputmask/jquery.inputmask.min.js"></script>
        <script src="../../../../bootstrap/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
        <script src="../../../../bootstrap/plugins/bs-stepper/js/bs-stepper.min.js"></script>
        <script src="../../../../bootstrap/plugins/dropzone/min/dropzone.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
        <script src="../../../../bootstrap/plugins/jszip/jszip.min.js"></script>
        <script src="../../../../bootstrap/plugins/pdfmake/pdfmake.min.js"></script>
        <script src="../../../../bootstrap/plugins/pdfmake/vfs_fonts.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-buttons/js/buttons.print.min.js"></script>
        <script src="../../../../bootstrap/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
        <script src="../../../../bootstrap/plugins/jquery-mousewheel/jquery.mousewheel.js"></script>
        <script src="../../../../bootstrap/plugins/jquery-mapael/jquery.mapael.min.js"></script>
        <script src="../../../../bootstrap/plugins/jquery-mapael/maps/usa_states.min.js"></script>
        <script src="../../../../bootstrap/plugins/raphael/raphael.min.js"></script>
        <script src="../../../../bootstrap/js/pages/dashboard2.js"></script>

</body>


<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $("#example2").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true,
            "buttons": ["excel", "pdf", "print"]
        }).buttons().container().appendTo('#example2_wrapper .col-md-6:eq(0)');
        $("#example3").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true
        });
        $("#example14").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": true
        });
        $("#example15").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [15, 50, 100, 500, 1000, -1],
                [15, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true
        });

    });
</script>





</html>