﻿<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Selamat Datang</title>
  <style>
	body {
	  margin: 0;
	  padding: 0;
	  font-family: 'Segoe UI', sans-serif;
	  background: url('assets/background.jpg') no-repeat center center fixed;
	  background-size: cover;
	  color: white;
	  overflow: hidden;
	  cursor: default;
	}

	.logo {
	  display: flex;
	  justify-content: center;
	  margin-top: 30px;
	}

	.logo img {
	  width: 120px;
	  height: auto;
	  border-radius: 12px;
	  box-shadow: 0 0 20px rgba(0, 240, 255, 0.5);
	}

	h1 {
	  text-align: center;
	  margin: 30px 20px 10px;
	  font-size: 2.2em;
	  z-index: 1;
	  position: relative;
	  text-shadow: 0 0 10px #00f0ff;
	}

	p {
	  text-align: center;
	  margin: 20px;
	  font-size: 1.2em;
	  z-index: 1;
	  position: relative;
	  text-shadow: 0 0 5px #00f0ff;
	}

	.menu {
	  display: flex;
	  flex-wrap: wrap;
	  justify-content: center;
	  gap: 20px;
	  margin: 30px 10px;
	  z-index: 1;
	  position: relative;
	}

	.menu a {
	  padding: 15px 30px;
	  background-color: rgba(0, 191, 255, 0.15);
	  border: 2px solid #00f0ff;
	  border-radius: 12px;
	  text-decoration: none;
	  color: #ffffff;
	  font-size: 1.2em;
	  transition: 0.3s ease;
	  box-shadow: 0 0 10px #00f0ff;
	  text-align: center;
	}

	.menu a:hover {
	  background-color: rgba(0, 191, 255, 0.3);
	  transform: scale(1.05);
	  box-shadow: 0 0 20px #00f0ff;
	}

	.star {
	  position: absolute;
	  width: 5px;
	  height: 5px;
	  background: white;
	  border-radius: 50%;
	  animation: float 6s linear infinite;
	  opacity: 0.8;
	}

	@keyframes float {
	  0% {
		transform: translateY(100vh) translateX(0);
		opacity: 0;
	  }
	  50% {
		opacity: 1;
	  }
	  100% {
		transform: translateY(-10vh) translateX(50px);
		opacity: 0;
	  }
	}

	footer {
	  text-align: center;
	  margin: 40px 10px 20px;
	  font-size: 0.9em;
	  color: #aaa;
	}

	footer a {
	  color: #00f0ff;
	  text-decoration: none;
	}

	footer a:hover {
	  text-decoration: underline;
	}

	@media (max-width: 600px) {
	  h1 {
		font-size: 1.6em;
	  }

	  .menu a {
		font-size: 1em;
		padding: 12px 20px;
	  }

	  p {
		font-size: 1em;
	  }

	  .logo img {
		width: 80px;
	  }
	}
  </style>
</head>
<body>

  <div class="logo">
	<img src="assets/logo.jpg" alt="Logo Yayasan">
  </div>

  <h1>Aplikasi Keuangan Sekolah</h1>

  <div class="menu">
	<a href="https://aks.panatagama.sch.id/kbtk">KB & TK</a>
	<a href="https://aks.panatagama.sch.id/sd">SD</a>
	<a href="https://aks.panatagama.sch.id/smp">SMP</a>
	<a href="https://aks.panatagama.sch.id/sma">SMA</a>
  </div>

  <h1>YAYASAN PANATAGAMA</h1>
  <p>"Menjadi lembaga pendidikan Islam modern yang menghasilkan generasi muslim unggul dalam iman, ilmu, dan amal”</p>

  <footer>
	Supported by <strong><a href="https://aplikasiaks.com" target="_blank">AKS-SIMAKOM</a></strong>
  </footer>

  <script>
	function createStar() {
	  const star = document.createElement('div');
	  star.classList.add('star');
	  star.style.left = Math.random() * window.innerWidth + 'px';
	  star.style.animationDuration = (3 + Math.random() * 5) + 's';
	  star.style.opacity = Math.random();
	  document.body.appendChild(star);

	  setTimeout(() => {
		star.remove();
	  }, 8000);
	}

	setInterval(createStar, 150);
  </script>

</body>
</html>
