DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text DEFAULT NULL,
  `notice2` text DEFAULT NULL,
  `tk` text DEFAULT NULL,
  `tp` varchar(10) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `id`) VALUES
	(1,'SMA Mulia Jakarta','Jl. Kemerdekaan No. 6 Jakarta','Jakarta','SMA','Nama Siswa','no','no','no','primary','','','primary','','','5','1','2023-10-01','','','Khumaira','123456789','Ahmad','1321654987','Kepala Sekolah','','','','','','','','TERIMA KASIH','2024/2025','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'SMA Mulia Jakarta','8F9E58-45722S-58677A-4BDE58-9412A2','E108AF12A2AF2DE9EE5B98CB56EFFCB4B0CBF1679A8ADB0F89A','2023-10-01','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Khamdi','L','khamdirahmani@gmail.com','085328635677','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','50463efa59739fd6caf07114793ee291'),
	(26,'d0f83653fdb01ed928a4','Siti','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','d0f83653fdb01ed928a4'),
	(27,'606ef979469528e637f6','Khumairah','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','606ef979469528e637f6'),
	(28,'4bc2be4245c022748235','Ahmad','L','','','kepala','870f669e4bbbfa8a6fde65549826d1c4','monitoring','Aktif','4bc2be4245c022748235'),
	(29,'6088971c048fb45e4317','Nisa','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','6088971c048fb45e4317');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB AUTO_INCREMENT=861 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user_siswa` (`no`, `nis`, `nama`, `kelamin`, `username`, `password`, `hp`, `email`, `id`, `status`, `created_at`, `updated_at`, `created_by`) VALUES
	(851,'240002','ACHMAD NUR RAICHAN','l','240002','42d5032e0ff118cf8b2f2e8499822326','085328635677','khamdirahmani@gmail.com','7e9adf970d42d5025efb','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(852,'240001','AFGHAN BHAZKARA JAYA NEGARA','l','240001','76074f612628b0b8b7639f6e244b4aa9','085328635677','khamdirahmani@gmail.com','13616df61576074bdc9b','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(853,'240003','Sunaryo Hadi Nugroho','L','240003','ee7c8e9b161ad434a06e4bdb0be6570f','085328635677','khamdirahmani@gmail.com','d4495876e6ee7c8ad95c','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(854,'240004','AMELIA JULIABET HIDAYATULLOH','p','240004','fa79be9131e64a6820fefd3cb222b522','085328635677','khamdirahmani@gmail.com','3a159974a7fa79b29158','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(855,'230002','AHMAD MUZAKY ULIN NUHA','l','230002','4dc8bfa0f2d3acdefaccf0e5df310398','085328635677','khamdirahmani@gmail.com','16231b78e74dc8b6b59b','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(856,'230001','AHMAD ZICKRY ZAELANI','l','230001','0e4f55ee70cf93625f5a53e7ef513750','085328635677','khamdirahmani@gmail.com','a3cf046af20e4f5e9377','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(857,'230003','AMIRA PRISCILLIA ELSAVA','p','230003','686ef63ffb6e33f1a1c737aae062775c','085328635677','khamdirahmani@gmail.com','03da0f3cd2686ef0056f','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(858,'220002','AISYAH SAFITRI RHAMADINI','p','220002','23849928de6fa6d2d7d5936879989838','085328635677','khamdirahmani@gmail.com','6b2e51e4cd23849d8475','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(859,'220001','ALEN YUDISTIRA','l','220001','4399406daccfd372eebf5887d42d8b73','085328635677','khamdirahmani@gmail.com','e6df02f9be4399446bbf','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291'),
	(860,'220003','AMIRAH NAJMINA FAJRI','p','220003','396e7970b19705db5196ae1142605539','085328635677','khamdirahmani@gmail.com','845d601770396e705483','Aktif','2024-08-01 20:30:54','2024-08-01 20:30:54','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(19,'A','100202','100202','Pendapatan Sewa GOR','be9bbf8e7cb2de034bee59162bafcaaefb0'),
	(17,'A','100103','100103','Penerimaan Biaya Akomodasi MMP','9ae26ff44c264acbcdb9f37bb5c08fcc9f9'),
	(18,'A','100201','100201','Pendapatan Ternak Ikan','7c7523f13ef609d154a6ac2187a5c8735fa'),
	(13,'A','100000','100000','Penerimaan Saldo Tahun Lalu','14ee22eaba29794682775be85f192af3021'),
	(14,'A','100101','100101','Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102','Penerimaan Sumbangan Pengembangan Sekolah','54ebda338d716823ef59a48ec57a173850c'),
	(16,'A','100104','100104','Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(20,'B','200101','200101','Belanja Honorarium Guru Tidak Tetap','fae1f94c506115ec42df2a0fd12dbe9c7aa'),
	(21,'B','200102','200102','Belanja Honorarium Pegawai Tidak Tetap','bc0db1ef7e8b6388b70ac689b02eee2cda0'),
	(22,'B','200103','200103','Belanja Honorarium Pembina Ekstra Internal','bd0b3e43c34a47ccdb67d115df7de21d9b8'),
	(23,'B','200104','200104','Belanja Honorarium Pembina Ekstra Eksternal','dde4acfdb0be07ac132ad5a295fc9f4b8ad'),
	(24,'B','200201','200201','Belanja Pemeliharaan Gedung dan Bangunan','fafe0a5ad92e1f86d2c833d5982ea8d01c1'),
	(25,'B','200202','200202','Belanja Pemeliharaan Peralatan dan Mesin','452bfed404cb95dbfaadfd1aa56e52d612a'),
	(26,'B','200301','200301','Belanja Keperluan Perkantoran','8aee09e623dfe2f7d11e4d0ad60d0a5ca38'),
	(27,'B','200302','200302','Belanja Bahan','004ca31ed6cc0360fe946d3365893f2b99d'),
	(28,'B','200401','200401','Belanja Jasa Profesi','9756342aa9434be8f1e85b87a4163c6354d'),
	(29,'B','200402','200402','Belanja Sewa','800d427f7b19cf62174b86e51875116f576'),
	(30,'B','200403','200403','Belanja Langganan Daya dan Jasa','de345b20a5d60aecea768241b2e0d2fcb0d'),
	(42,'B','200107','200107','Belanja Honorarium THR Guru Tidak Tetap','6752ca88e78474b7acd301cfefc889b658a'),
	(41,'B','200106','200106','Belanja Penunjang Kegiatan Pendidikan','7a303a097dd4e0259280330a6809291f824'),
	(34,'B','299999','299999','Belanja Lainnya','94cfaff110fc98938230b1e4e53541cfbc5'),
	(35,'B','200105','200105','Belanja Honor Kegiatan','e085d8a5248ec1cee089e4a2bff2e804231'),
	(36,'A','100301','100301','Bantuan Operasional Sekolah (BOS)','a6061a0c10b13bf137460ec8e143a214b05'),
	(37,'A','199999','199999','Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105','Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(39,'B','200501','200501','Belanja Perjaanan Dinas','269727a2b342292f278b69e51643ea9e1b8'),
	(40,'B','200210','200210','Belanja Pengadaan Tanah','71464592903d1ac6bfb8cdcfed812c0c969'),
	(43,'B','200108','200108','Belanja Honorarium THR Pegawai Tidak Tetap','1fdbafb8171bc612ee72f9fa507f8e4fa32'),
	(44,'B','200109','200109','Belanja Honorarium Ke-13 Guru Tidak Tetap','b746153e7a27362c6c611539f2d9acd0094'),
	(45,'B','200110','200110','Belanja Honorarium Ke-13 Pegawai Tidak Tetap','f234d714e94e229d926d70b864ce568ad54'),
	(46,'B','200111','200111','Belanja Tunjangan Reward Kehadiran Guru Tidak Tetap','6e59975fd49e3d83bcf5381468064911efa'),
	(47,'B','200112','200112','Belanja Tunjangan Reward Kehadiran Pegawai Tidak Tetap','8655f16996c8058e106e2bc0ab56d9a4f0b'),
	(48,'B','200113','200113','Belanja Honorarium Petugas Piket Hari Libur','d6155c6ec9d14c2bdc408fb3fe9db1bfa3e'),
	(49,'A','100302','100302','Uang Kegiatan','8acdf12cd77f6e7b488840a65a20ab6e33d');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617682775be85f192af3021','A','1000','1000','Penerimaan Saldo Tahun Lalu'),
	(113,'b8c37e33defde51c9354242c284f97a5e37','A','1001','1001','Penerimaan Sumbangan Masyarakat'),
	(114,'5ec829debe54b19f0c285f19d5f8238d516','A','1999','1999','Penerimaan Lain'),
	(115,'fba9d88164f3e2d96797f48c50918cfed34','A','1002','1002','Penerimaan Pendapatan Asli sekolah'),
	(116,'08f90c1a41715538b72664c9498459011e6','B','2000','2000','Belanja Kegiatan Standar Kelulusan'),
	(117,'d0fb963ff976f9c653181e9d8ca9683b483','B','2001','2001','Belanja Kegiatan Standar Isi'),
	(118,'4ba29b9f9e5732ec04affa66cf010b62572','B','2002','2002','Belanja Kegiatan Standar Proses'),
	(119,'a591024321c5e2b16506375d817b0241e6f','B','2003','2003','Belanja Kegiatan Standar Pengelolaan'),
	(120,'b8b4b727d6f5d1b10479106d6c3105ea2a5','B','2004','2004','Belanja Kegiatan Standar Tendik'),
	(121,'d47268e9db2e9aa32fc56790236f069da49','B','2005','2005','Belanja Kegiatan Standar Pembiayaan'),
	(122,'ea5a486c712a91eb215f8699c222f811cdc','B','2006','2006','Belanja Kegiatan Standar Sarana Prasarana'),
	(123,'a00e5eb0973d2463c5686760dfed4295acd','B','2007','2007','Belanja Kegiatan Standar Penilaian'),
	(124,'aa68c75c4a77c870bcef3a2582241da86d0','A','1003','1003','Penerimaan Uang Kegiatan'),
	(125,'a36e841c5230a796600fd02a16301a5fb97','B','2999','2999','Belanja Lain-lain');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','11'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','12'),
	(34,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B10','','10'),
	(35,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B8','','11'),
	(36,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B9','','12'),
	(53,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C8','','11'),
	(54,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C9','','12'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALulus','','LULUS'),
	(62,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C7','','10'),
	(63,'2024/2025','Spp','A','Ya','2024/2025A10','','10'),
	(64,'2024/2025','Spp','A','Ya','2024/2025A11','','11'),
	(65,'2024/2025','Spp','A','Ya','2024/2025A12','','12'),
	(66,'2024/2025','Uang Kegiatan','B','Tidak','2024/2025B10','','10'),
	(67,'2024/2025','Uang Kegiatan','B','Tidak','2024/2025B11','','11'),
	(68,'2024/2025','Uang Kegiatan','B','Tidak','2024/2025B12','','12'),
	(69,'2024/2025','Kas Kelas','C','Ya','2024/2025C10','','10'),
	(70,'2024/2025','Kas Kelas','C','Ya','2024/2025C11','','11'),
	(71,'2024/2025','Kas Kelas','C','Ya','2024/2025C12','','12'),
	(72,'2024/2025','Seragam','D','Tidak','2024/2025D10','','10'),
	(73,'2024/2025','Seragam','D','Tidak','2024/2025D11','','11'),
	(74,'2024/2025','Seragam','D','Tidak','2024/2025D12','','12');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','B','Aktif'),
	(21,'0d61f8370cad82c486547f599','C','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','A','Aktif'),
	(24,'f623e75af30e6f2052d0bd5ba','D','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','E','Aktif'),
	(26,'800618943025ed73eb5b6b972','F','Aktif'),
	(27,'dfcf28d07345df1fb088c98f0','G','Aktif'),
	(33,'e11c1bc57b97131059d58b826','LULUS','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(6,'KKO','de3ad54b3bd47253639bd484582','2023-07-31 08:45:02');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(13,'2023/2024','','2023-07-10 14:24:48','5531a5834816c3f04945cbc9d','2023-07-10 14:24:48','113ccaa98a0a30bc5204ed2fccc9c515'),
	(14,'2024/2025','','2024-07-31 15:06:34','07811dc6c422716ddfc654e11','2024-07-31 15:06:34','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_walikelas` (`no`, `tp`, `jenjang`, `paralel`, `nama`, `nip`, `id`, `created_at`, `created_by`) VALUES
	(1,'2023/2024','10','A','Siti Munawaroh, S. Pd','123456789','7564a25f9e600f6062c9','2023-10-01 21:24:02','113ccaa98a0a30bc5204ed2fccc9c515'),
	(2,'2023/2024','11','A','Sunari, S. Pd','2334566789','699781fdd84031dc76c0','2023-10-01 21:24:56','113ccaa98a0a30bc5204ed2fccc9c515'),
	(3,'2023/2024','12','A','Kurniasari, S. Pd','334567894','64e6a875450b8503641a','2023-10-01 21:25:16','113ccaa98a0a30bc5204ed2fccc9c515');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text DEFAULT NULL,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text NOT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','','','','0','','','0','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(1,'2021/2022','close','2023-04-19 09:37:32','2023-04-20 14:07:52','butab','38eafdfd8861dsfsfserw'),
	(21,'2022/2023','close','2023-04-20 11:33:23','2023-10-03 05:06:19','tabungan','38eafdfa86559e303bd0'),
	(22,'2023/2024','close','2023-04-21 19:57:26','2024-08-02 11:42:40','tabungan','da6363e171cecab03bd0'),
	(23,'2024/2025','open','2024-08-02 11:42:28','1901-01-01 00:00:00','','b97ac6447c86e79c1b1f');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2425`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_komponen2425` (`no`, `kategori`, `kegiatan`, `komponen`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(2,'A','1002','A','INFAQ','A1002A','7fc5688164f3e2d270e7a70fa81a5935b72eacbe2924-02','2'),
	(3,'B','2999','A','OPERASIONAL','B2999A','9d5ed41c5230a79270e7a70fa81a5935b72eacbe2924-02','2'),
	(4,'A','1002','A','INFAQ','A1002A','7fc56270e7a70fa88164f3e2d270e7a70fa6364d','3'),
	(5,'B','2999','A','OPERASIONAL','B2999A','9d5ed678fe57bcc41c5230a79270e7a70fa182be','3');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2425`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_kegiatan2425` (`no`, `kategori`, `kegiatan`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','Penerimaan Saldo Tahun Lalu','A1000','7fc56270e7a70faa70783b617e9998dc4ddc4ca4','1'),
	(2,'B','2999','Belanja Lain-lain','B2999','9d5ed678fe57bcc41c5230a79c2102036d2c4ca4','1'),
	(4,'B','2999','Belanja Lain-lain','B2999','9d5ed678fe57bcc41c5230a79c2102036d2b6d76','2'),
	(5,'A','1002','Penerimaan Pendapatan Asli sekolah','A1002','7fc56270e7a70fa88164f3e2d9109ee7702c81e7','2'),
	(6,'B','2999','Belanja Lain-lain','B2999','9d5ed678fe57bcc41c5230a79c2102036d2e3698','3'),
	(7,'A','1002','Penerimaan Pendapatan Asli sekolah','A1002','7fc56270e7a70fa88164f3e2d9109ee77021c383','3');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2425`;

CREATE TABLE IF NOT EXISTS `simakom_akun2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_akun2425` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `uraian`, `kode_id`, `akun_id`, `id`, `revisi`) VALUES
	(2,'A','1002','A',100101,'Penerimaan SPP','A1002A','A1002100101A','6ec857fc569d881270e7a70fa81a5935b72eacbe2924-02','2'),
	(3,'B','2999','A',200301,'Belanja Keperluan Perkantoran','B2999A','B2999200301A','e623d9d5ede841c270e7a70fa81a5935b72eacbe2924-02','2'),
	(4,'A','1002','A',100101,'Penerimaan SPP','A1002A','A1002100101A','7fc56270e788164f3e2d270e7a70fa76ec86364d','3'),
	(5,'B','2999','A',200301,'Belanja Keperluan Perkantoran','B2999A','B2999200301A','9d5ed678fe41c5230a79270e7a70fa9e623182be','3'),
	(6,'B','2999','A',200101,'Belanja Honorarium Guru Tidak Tetap','B2999A','B2999200101A','4c5069d5ede841c270e7a70fa81a5935b72eacbe2924-07','3'),
	(7,'B','2999','A',200102,'Belanja Honorarium Pegawai Tidak Tetap','B2999A','B2999200102A','ef7e89d5ede841c270e7a70fa81a5935b72eacbe2924-07','3'),
	(8,'B','2999','A',200302,'Belanja Bahan','B2999A','B2999200302A','1ed6c9d5ede841c270e7a70fa81a5935b72eacbe2924-07','3');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2425`;

CREATE TABLE IF NOT EXISTS `simakom_detail2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_detail2425` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `detail`, `detail_id`, `uraian`, `volume`, `satuan`, `unit`, `total`, `komponen_1`, `komponen_2`, `komponen_3`, `komponen_4`, `unit_1`, `unit_2`, `unit_3`, `unit_4`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `revisi`, `time`, `kode_id`, `id`) VALUES
	(1,'A','1002','A',100101,1,'A1002A10010100100','INFAQ','9','1200000','siswa','10800000','','','','','','','','','','','','','2','2024-02-07 15:53:25','A1002A','6ec571b48cc86626ae766f543cd98f00'),
	(2,'B','2999','A',200301,1,'B2999A20030100100','OPERASIONAL','1','5000000','tahun','5000000','','','','','','','','','A1002A10010100100','1002','A','100101','2','2024-02-07 15:55:19','B2999A','e623455a423adbbd8eadbbd8e76ec85f'),
	(3,'A','1002','A',100101,1,'A1002A10010100100','INFAQ','9','1200000','siswa','10800000','','','','','','','','','','','','','3','2024-07-17 12:30:36','A1002A','6ec571b48cc86626766f5cd98f0c16a5'),
	(4,'B','2999','A',200301,1,'B2999A20030100100','OPERASIONAL','1','5000000','tahun','5000000','','','','','','','','','A1002A10010100100','1002','A','100101','3','2024-07-17 12:30:36','B2999A','e623455a423adbbdadbbd76ec856364d'),
	(5,'B','2999','A',200302,1,'B2999A20030200100','MAKAN','1','10','TAHUN','10','','','','','','','','','A1002A10010100100','1002','A','100101','3','2024-07-19 10:33:50','B2999A','1edd577a42346802a446802a476ec85f');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2425`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_jurnal2425` (`no`, `tanggal`, `jenis`, `jumlah`, `uraian`, `id`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'2024-07-15','8','500000',' ','7215eec9f0f855996fe3702a','2024-07-15 22:03:41','2024-07-15 22:03:41','bendahara');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2425`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_revisi2425` (`no`, `revisi`, `tanggal`, `time`, `id`) VALUES
	(1,'0','2024-02-07','2024-02-07 15:32:59','d9efc2e772b67d652c4676f8819766d12bf'),
	(2,1,'2024-02-07','2024-02-07 15:33:11','d9efc2e772b67d6b96c19e4eca078ff2e6f'),
	(3,2,'2024-02-07','2024-02-07 15:35:08','d9efc2e772b67d667b0246eae101d84d052'),
	(4,3,'2024-07-17','2024-07-17 12:30:36','ae74e64e015aa2f84c2faf885be006fe426');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2425`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_transaksi2425` (`no`, `tanggal`, `bukti`, `bukti_sistem`, `jenis`, `kategori`, `rkas_kategori`, `rkas_kegiatan`, `rkas_komponen`, `rkas_akun`, `rkas_detail_id`, `uraian`, `debet`, `kredit`, `penerima`, `penerima_jabatan`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `pajak`, `pajak_akun`, `revisi`, `id_setor`, `time`, `id`) VALUES
	(1,'2024-08-16',1,200000,31,'B1','B','2999','A',200301,'B2999A20030100100','Belanja  OPERASIONAL','0','500000','CIMOL','PENGUASA','A1002A10010100100','1002','A','100101','0','','2','','2024-02-07 16:13:53','20ff29f777328d9d4cec85f14e663faef225d06612c588164f3'),
	(2,'2024-07-17',2,200001,11,'A1','A','1002','A',100101,'A1002A10010100100','Terima  INFAQ','310000','0',NULL,NULL,'','','','','0','','2','F901D15222364E015A','2024-07-17 12:25:51','8d9fa71a19f28d9d4cec85f14e663faef225d06612c5e67f731');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2425`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `simakom_lpj2425` (`no`, `tanggal`, `periode`, `tahun`, `bku_awal`, `bku_debet`, `bku_kredit`, `bku_akhir`, `bank_awal`, `bank_debet`, `bank_kredit`, `bank_akhir`, `tunai_awal`, `tunai_debet`, `tunai_kredit`, `tunai_akhir`, `bank_riil`, `tunai_riil`, `bank_selisih`, `tunai_selisih`, `selisihtunai_keterangan1`, `selisihtunai_keterangan2`, `selisihbank_keterangan1`, `selisihbank_keterangan2`, `rekening_nama1`, `rekening_jumlah1`, `rekening_nama2`, `rekening_jumlah2`, `rekening_nama3`, `rekening_jumlah3`, `catatan`, `pecahan_100`, `pecahan_75`, `pecahan_50`, `pecahan_20`, `pecahan_10`, `pecahan_5`, `pecahan_2`, `pecahan_1`, `pecahan_05`, `pecahan_02`, `pecahan_01`, `pecahan_005`, `id`) VALUES
	(1,'2024-07-31','1','2024/2025','0','310000','0','310000','0','0','0','0','0','310000','0','310000','1500000','310000','1500000','0','','','Uang Titipan Wali Murid','','BRI No. 123456','1500000','','0','','0','','3','0','0','0','1','0','0','0','0','0','0','0','c4ca464d276799cd590a96ec33ea48');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2425`;

CREATE TABLE IF NOT EXISTS `db_setor2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `db_setor2425` (`no`, `tanggal_draf`, `jumlah`, `uraian`, `setor_status`, `setor_tanggal`, `terima_status`, `terima_tanggal`, `penyetor`, `penerima`, `metode`, `id_rkas`, `tahun`, `id_setor`, `created_by`, `created_at`, `id`) VALUES
	(5,'2024-08-14 00:00:00','','','2','2024-02-07 16:17:57','1','2024-02-07 16:18:20','50463efa59739fd6caf07114793ee291','','1','','2024/2025','ac0d41dd8cd6d23eae','50463efa59739fd6caf07114793ee291','2024-02-07 16:16:04','ac0d41dd8cd6d23eae'),
	(8,'2024-07-17 00:00:00','','Terima  INFAQ','3','2024-07-17 12:24:03','1','2024-07-17 12:25:51','6088971c048fb45e4317','606ef979469528e637f6','1','A1002A10010100100','2024/2025','f901d15222364e015a','6088971c048fb45e4317','2024-07-17 12:17:29','f901d15222364e015a'),
	(9,'2024-08-01 00:00:00','','zz','1','0000-01-01 00:00:00','1','0000-01-01 00:00:00','50463efa59739fd6caf07114793ee291','','1','','2024/2025','c27d41dd1bca3b7c33','50463efa59739fd6caf07114793ee291','2024-08-01 12:45:27','c27d41dd1bca3b7c33');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tb_siswa_min2425` (`no`, `nama`, `nis`, `jenjang`, `paralel`, `id`) VALUES
	(30,'AMELIA JULIABET HIDAYATULLOH','240004','10','C','fa79be9131056542721f'),
	(31,'ALEN YUDISTIRA','220001','12','B','4399406dacb4f89b8064'),
	(32,'AISYAH SAFITRI RHAMADINI','220002','12','A','23849928deacc328d8b0'),
	(33,'AHMAD ZICKRY ZAELANI','230001','11','B','0e4f55ee704d89b36d03'),
	(34,'AHMAD MUZAKY ULIN NUHA','230002','11','A','4dc8bfa0f2140ad3309c'),
	(35,'AFGHAN BHAZKARA JAYA NEGARA','240001','10','B','76074f6126fdc7847ef0'),
	(36,'ACHMAD NUR RAICHAN','240002','10','A','42d5032e0f9d5f2e0298'),
	(37,'AMIRA PRISCILLIA ELSAVA','230003','11','C','686ef63ffb81613158d2'),
	(38,'AMIRAH NAJMINA FAJRI','220003','12','C','396e7970b1c56af08e96'),
	(39,'Sunaryo Hadi Nugroho','240003','10','B','ee7c8e9b16818e691c19');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tb_siswa2425` (`no`, `nama`, `nis`, `kelamin`, `jenjang`, `paralel`, `ortu`, `alamat`, `tang_A`, `tang_B`, `tang_C`, `tang_D`, `tang_E`, `tang_F`, `tang_G`, `tang_H`, `tang_I`, `tang_J`, `tang_K`, `tang_L`, `tang_M`, `tang_N`, `tang_O`, `tang_P`, `tang_Q`, `tang_R`, `tang_S`, `tang_T`, `tang_U`, `tang_V`, `tang_W`, `tang_X`, `tang_Y`, `tang_Z`, `status`, `email`, `hp`, `kategori`, `startAt`, `id`) VALUES
	(30,'AMELIA JULIABET HIDAYATULLOH','240004','p','10','C','','','0','360000','100000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','085226995677','Umum','1','fa79be9131056542721f'),
	(31,'ALEN YUDISTIRA','220001','l','12','B','','','1200000','360000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','4399406dacb4f89b8064'),
	(32,'AISYAH SAFITRI RHAMADINI','220002','p','12','A','','','1200000','360000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','23849928deacc328d8b0'),
	(33,'AHMAD ZICKRY ZAELANI','230001','l','11','B','','','1200000','360000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','0e4f55ee704d89b36d03'),
	(34,'AHMAD MUZAKY ULIN NUHA','230002','l','11','A','','','1200000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','','1','4dc8bfa0f2140ad3309c'),
	(35,'AFGHAN BHAZKARA JAYA NEGARA','240001','l','10','B','','','1200000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','','1','76074f6126fdc7847ef0'),
	(36,'ACHMAD NUR RAICHAN','240002','l','10','A','','','1200000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','','1','42d5032e0f9d5f2e0298'),
	(37,'AMIRA PRISCILLIA ELSAVA','230003','p','11','C','','','1200000','600000','120000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','08321292404','Umum','1','686ef63ffb81613158d2'),
	(38,'AMIRAH NAJMINA FAJRI','220003','p','12','C','','','0','72000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','396e7970b1c56af08e96'),
	(39,'Sunaryo Hadi Nugroho','240003','L','10','B','Test','Ja','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','shp@gmail.com','08222222','Umum','1','ee7c8e9b16818e691c19');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2425`;

CREATE TABLE IF NOT EXISTS `payment_list2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `payment_list2425` (`no`, `tanggal`, `nis`, `nama`, `jenjang`, `paralel`, `hp`, `email`, `jumlah`, `status`, `keterangan`, `payment_id`, `tahun`, `created_at`, `id`) VALUES
	(1,'2024-08-01','8970','ACHMAD NUR RAICHAN','10','A','','','300000','DRAF','','SIMAKOM2425_8970_F96B81C66DE9E32','2024/2025','2024-08-01 20:16:02','baf1ec38150d2df2a69cfdf331a71442'),
	(2,'2024-08-01','240001','AFGHAN BHAZKARA JAYA NEGARA','10','B','','','100000','CONFIRM','','SIMAKOM2425_240001_D52A09E42F6773E','2024/2025','2024-08-01 20:40:23','e40f486b1fe8fb9b24512f36ce0bd8c1');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `payment_set` (`no`, `aktif`, `sistem`, `api`, `callback`, `fee`, `id`) VALUES
	(1,'','','','','0','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2425`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tabungan_siswa2425` (`no`, `nama`, `nis`, `rekening`, `kelamin`, `saldo`, `status`, `id`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'ADHITYA NUR RAHMAT','230002','230002','L','40000','Aktif','4d32e045c04dc8b13523','2024-07-09 07:34:37','2024-07-09 07:34:37','d0f83653fdb01ed928a4'),
	(2,'AHMAD ROMADHON','230003','230003','L','50000','Aktif','e7b90eb764686ef13523','2024-07-09 07:34:37','2024-07-09 07:34:37','d0f83653fdb01ed928a4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2425`;

CREATE TABLE IF NOT EXISTS `db_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `db_transaksi2425` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `id`) VALUES
	(16,'2024-08-01 00:00:00','240002','ACHMAD NUR RAICHAN','l','10','A','A',1,'100000','2581065LTFCD','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-01 20:38:42','140.213.167.142','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36','3B5948032ED301','5DCB221FSHH0PG757227'),
	(17,'2024-08-01 00:00:00','240002','ACHMAD NUR RAICHAN','l','10','A','A',2,'100000','25810587WY1E','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-01 20:38:42','140.213.167.142','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36','3B5948032ED301','8A4F6090ABTBUOXF9D94'),
	(18,'2024-08-01 00:00:00','220002','AISYAH SAFITRI RHAMADINI','p','12','A','A',1,'100000','DA8FEMZG8O54','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-01 20:39:12','140.213.167.142','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36','034DD6992822B8','CB58B819YBMNPY54546C'),
	(19,'2024-08-01 00:00:00','220002','AISYAH SAFITRI RHAMADINI','p','12','A','B',1,'60000','DA8FE9R1SSC5','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-01 20:39:12','140.213.167.142','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36','034DD6992822B8','532A7568ZLAO3652DCD5'),
	(20,'2024-08-02 00:00:00','240002','ACHMAD NUR RAICHAN','l','10','A','A',3,'100000','5C9DD3FLVO01','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-02 11:42:13','103.83.93.251','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36','2ED789032EB7C0','48D242505DJEETX9FD2E'),
	(21,'2024-08-02 00:00:00','240002','ACHMAD NUR RAICHAN','l','10','A','A',4,'200000','D9E94TV2L9CF','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-02 11:42:36','103.83.93.251','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36','66232B032EC7C5','0B5979DBVQ67J7V5953F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2425`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tabungan_transaksi2425` (`no`, `tanggal`, `nis`, `nama`, `jenis`, `jumlah`, `jurnal`, `catatan`, `created_by`, `created_at`, `id`) VALUES
	(1,'2024-07-19','230002','ADHITYA NUR RAHMAT','K','39000','','','d0f83653fdb01ed928a4','2024-07-19 07:31:15','8d54b777a707645772744d32e'),
	(2,'2024-07-19','230002','ADHITYA NUR RAHMAT','D','150000','','','d0f83653fdb01ed928a4','2024-07-19 12:55:43','8d54bb9173a75314abbe4d32e'),
	(3,'2024-07-19','230003','AHMAD ROMADHON','K','50000','','','d0f83653fdb01ed928a4','2024-07-19 12:57:21','bdb5ddd9d37d5f71017be7b90');

-- ------------------------------------------------ 

