<?php
error_reporting(1);
$time = new time;
$format = new format;
$classTr = new transaksi;
$tglsekarang = $time->getDateInput();
$cekpost = new cekissetPost();

$tahunAsal = $cekpost->cek('tahun_asal');
?>

<style>
    /* Styling untuk spinner */
    #loadingSpinner {
        display: none;
        /* Default disembunyikan */
        position: fixed;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        font-size: 18px;
        text-align: center;
        color: #4cdf14;

    }

    /* Style untuk elemen spinner */
    #loadingSpinner .spinner {
        border: 4px solid #f3fbf0;
        /* Warna latar belakang spinner */
        border-top: 4px solid #4cdf14;
        /* Warna bagian atas spinner */
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 1s linear infinite;
        /* Animasi berputar */
        margin: 0 auto 10px;
        /* Centering */
    }


    /* Style untuk teks "Loading" 
    #loadingSpinner .loading-text {
        font-size: 18px;
        color: #ed3223;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
        */
</style>
<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-gear"></span> PROSES SETOR KE BENDAHARA ASAL TAHUN <?php echo $tahunAsal; ?></b>
                        </div>
                        <div class="card-body mx-2 ">
                            <?php require('./view/setor/headerpage.php'); ?>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body mb-4 mx-4">

                            <div class="row mt-0">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Data Setor </label>
                                <div class="col-lg-3 col-sm-12">
                                    <input type="text" id="search" placeholder="Tanggal Draf" class="form-control form-control-sm fontInput">
                                </div>

                            </div>

                            <div id="loadingSpinner">
                                <div class="spinner"></div>
                                <div class="loading-text">Sedang Proses Download...</div>
                            </div>
                            <table class="table table-condensed table-sm mb-4 mt-3">
                                <thead>
                                    <tr>

                                        <th>No</th>
                                        <th data-sort="tanggal_draf" class="sortable">Tanggal <span class="sort-icon" style="color: red;">⇅</span></th>
                                        <th>ID Setor</th>
                                        <th>Penyetor</th>
                                        <th>Detail [Akun] RKAS</th>
                                        <th>Jumlah Draf</th>
                                        <th>Jumlah Proses</th>
                                        <th>Record Transaksi</th>
                                        <th>Metode</th>
                                        <th data-sort="setor_status" class="sortable">Status Setor<span class="sort-icon" style="color: red;">⇅</span></th>
                                        <th>Proses Terima</th>
                                        <th>Cetak Tanda Terima</th>

                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>

                            <br><br>



                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        let orderBy = "tanggal_draf"; // Default kolom sorting
        let orderDir = "DESC"; // Default arah sorting

        function loadData(page = 1, limit = 100, search = '') {
            $('#spinner').show();
            $.ajax({
                url: 'view/setor/fetch/fetch_setor_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search,
                    orderBy,
                    orderDir,
                    tahunAsal: <?php echo json_encode($tahunAsal); ?>
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        }


        // Klik header untuk sorting
        $('.sortable').click(function() {
            let column = $(this).data("sort");
            if (orderBy === column) {
                orderDir = orderDir === "ASC" ? "DESC" : "ASC";
            } else {
                orderBy = column;
                orderDir = "ASC";
            }
            loadData(1, $('#limit').val(), $('#search').val());
        });

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();

            const delete_reason = $('#delete_reason').val().trim();
            if (ids.length > 0 && delete_reason !== '') {
                $.post('view/transaksi/fetch/fetch_transaksi_delete.php', {
                    ids: ids,
                    delete_reason: delete_reason
                }, function(response) {
                    const res = JSON.parse(response);
                    alert(res.message);
                    location.reload();

                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }
        });


        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        $('#exportButtonXlsx').click(function() {
            $('#loadingSpinner').show(); // Tampilkan spinner

            $.ajax({
                url: 'view/setor/export_xlsx.php',

                type: 'POST',
                xhrFields: {
                    responseType: 'blob' // Mengatur respon sebagai file blob
                },
                success: function(data) {
                    // Buat objek URL dari blob
                    const blob = new Blob([data], {
                        type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                    });
                    const url = window.URL.createObjectURL(blob);

                    // Buat link untuk mengunduh file
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'Data_Setor.xlsx';
                    document.body.appendChild(a);
                    a.click();

                    // Hapus link dan URL sementara
                    window.URL.revokeObjectURL(url);
                    $('#loadingSpinner').hide(); // Sembunyikan spinner
                },
                error: function() {
                    alert('Terjadi kesalahan saat mengekspor data.');
                    $('#loadingSpinner').hide(); // Sembunyikan spinner
                }
            });
        });

        loadData();
    });
</script>