<?php

set_time_limit(0);
spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';
$classsekolah = new sekolah();
$sekolah = $classsekolah->dataSekolah('sekolah');
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);
$tahunnow = date("Y", $tanggal);


if (isset($_GET['tahun'])) {
    $tahun = $_GET['tahun'];
} else {
    $tahun = $tahunnow;
};

$tb_transaksi = "simakom_transaksi" . substr($tahun, 2, 2) . substr($tahun, 7, 2);

if (isset($_GET['tanggal'])) {
    $tanggal = $_GET['tanggal'];
} else {
    $tanggal = $tglsekarang;
};
if (isset($_GET['buku'])) {
    $buku = $_GET['buku'];
} else {
    $buku = 1;
};
if (isset($_GET['bulan'])) {
    $bulan = $_GET['bulan'];
} else {
    $bulan = 1;
};

$classBuku = new simakom_laporan();
$buku_judul = strtoupper($classBuku->jenisBuku($buku));
$periode = strtoupper($classBuku->Periode($bulan, $tahun));

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Writer\Xlsx\Writer;

$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
$spreadsheet->setActiveSheetIndex(0);



//$spreadsheet = new Spreadsheet();
$sheet1 = $spreadsheet->setActiveSheetIndex(0);
$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
$writer->setPreCalculateFormulas(false); // Percepat
$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);
$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$spreadsheet->getActiveSheet()->getPageMargins()->setTop(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(1);
// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_judul = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],

];
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];


$sheet1->getStyle('A1')->getFont()->setBold(true);
$sheet1->getStyle('A1')->getFont()->setSize(15);
//$sheet1->getStyle('A1:G1000')->getFont()->setName('Arial');
//$lastRow = $sheet1->getHighestRow();
//$sheet1->getStyle("A1:G$lastRow")->getFont()->setName('Arial');
//for ($i = 'A'; $i !=  $sheet1->getHighestColumn(); $i++) {
//    $sheet1->getColumnDimension($i)->setAutoSize(TRUE);
//}


if ($buku == 4) {
    $sheet1->getColumnDimension('A')->setWidth(5);
    $sheet1->getColumnDimension('B')->setWidth(14);
    $sheet1->getColumnDimension('C')->setWidth(12);
    $sheet1->getColumnDimension('D')->setWidth(60);
    $sheet1->getColumnDimension('E')->setWidth(15);
    $sheet1->getColumnDimension('F')->setWidth(15);
    $sheet1->getColumnDimension('G')->setWidth(15);
    $sheet1->getColumnDimension('H')->setWidth(15);
    $sheet1->getColumnDimension('I')->setWidth(15);
    $sheet1->getColumnDimension('J')->setWidth(15);
    $sheet1->getColumnDimension('K')->setWidth(15);

    $sheet1->setCellValue('A1', $buku_judul);
    $sheet1->setCellValue('A2', $sekolah);
    $sheet1->mergeCells('A1:K1');
    $sheet1->mergeCells('A2:K2');

    $sheet1->setCellValue('A5', 'PERIODE');
    $sheet1->setCellValue('C5', ': ' . $periode);
    $sheet1->getStyle('A5:C5')->getFont()->setBold(true);

    $sheet1->getStyle('A1:K1000')->getFont()->setName('Arial');
    $sheet1->getStyle('A7:K1000')->getFont()->setSize(10);

    // Buat header tabel nya pada baris ke 3
    $sheet1->setCellValue('A7', 'No');
    $sheet1->setCellValue('B7', 'No Bukti');
    $sheet1->setCellValue('C7', ' Tanggal ');
    $sheet1->setCellValue('D7', ' Uraian ');
    $sheet1->setCellValue('E7', ' Pasal 21 ');
    $sheet1->setCellValue('F7', ' Pasal 22  ');
    $sheet1->setCellValue('G7', ' Pasal 23  ');
    $sheet1->setCellValue('H7', ' Pasal 4  ');
    $sheet1->setCellValue('I7', ' PPN  ');
    $sheet1->setCellValue('J7', ' Kredit  ');
    $sheet1->setCellValue('K7', ' Saldo  ');

    // Apply style header yang telah kita buat tadi ke masing-masing kolom header
    $sheet1->getStyle('A1:K1')->applyFromArray($style_judul);
    $sheet1->getStyle('A2:K2')->applyFromArray($style_judul);

    $spreadsheet->getActiveSheet(1)->getStyle('A7:K7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
    $sheet1->getStyle('A7:K7')->applyFromArray($style_row);
} else {
    $sheet1->getColumnDimension('A')->setWidth(5);
    $sheet1->getColumnDimension('B')->setWidth(14);
    $sheet1->getColumnDimension('C')->setWidth(12);
    $sheet1->getColumnDimension('D')->setWidth(60);
    $sheet1->getColumnDimension('E')->setWidth(15);
    $sheet1->getColumnDimension('F')->setWidth(15);
    $sheet1->getColumnDimension('G')->setWidth(15);

    $sheet1->setCellValue('A1', $buku_judul);
    $sheet1->setCellValue('A2', $sekolah);
    $sheet1->mergeCells('A1:G1');
    $sheet1->mergeCells('A2:G2');

    $sheet1->setCellValue('A5', 'PERIODE');
    $sheet1->setCellValue('C5', ': ' . $periode);
    $sheet1->getStyle('A5:C5')->getFont()->setBold(true);

    $sheet1->getStyle('A1:G10000')->getFont()->setName('Arial');
    $sheet1->getStyle('A7:G10000')->getFont()->setSize(10);

    // Buat header tabel nya pada baris ke 3
    $sheet1->setCellValue('A7', 'No');
    $sheet1->setCellValue('B7', 'No Bukti');
    $sheet1->setCellValue('C7', ' Tanggal ');
    $sheet1->setCellValue('D7', ' Uraian ');
    $sheet1->setCellValue('E7', ' Debet ');
    $sheet1->setCellValue('F7', ' Kredit  ');
    $sheet1->setCellValue('G7', ' Saldo  ');

    // Apply style header yang telah kita buat tadi ke masing-masing kolom header
    $sheet1->getStyle('A1:G1')->applyFromArray($style_judul);
    $sheet1->getStyle('A2:G2')->applyFromArray($style_judul);

    $spreadsheet->getActiveSheet(1)->getStyle('A7:G7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
    $sheet1->getStyle('A7:G7')->applyFromArray($style_row);
};

// Set height baris ke 1, 2 dan 3
$sheet1->getRowDimension('1')->setRowHeight(20);


$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 8;

$class = new simakom_laporan();
if ($buku == 1) {
    $showList = $class->list_bku_xlsx($sheet1, $style_row, $tb_transaksi, $bulan, $tahun);
} elseif ($buku == 2) {
    $showList = $class->list_bukuTunai_xlsx($sheet1, $style_row, $tb_transaksi, $bulan, $tahun);
} elseif ($buku == 3) {
    $showList = $class->list_bukuBank_xlsx($sheet1, $style_row, $tb_transaksi, $bulan, $tahun);
} elseif ($buku == 4) {
    $showList = $class->list_bukuPajak_xlsx($sheet1, $style_row, $tb_transaksi, $bulan, $tahun);
};


$spreadsheet->getActiveSheet()->setTitle($buku_judul);


// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . $buku_judul . ' ' . $periode . '.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
ob_end_clean();
$writer->save('php://output');
