<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$limit = 100; // Jumlah data per halaman
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$search = isset($_POST['search']) ? $_POST['search'] : '';

$offset = ($page - 1) * $limit;
//$query = "SELECT  * FROM  $tb_transaksi group by id_tr WHERE nama LIKE :search || nis LIKE :search order by tanggal desc LIMIT :limit OFFSET :offset";
$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search group by id_tr order by tanggal desc LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$no = 0;
//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$output = '<table  cellpadding="10" class="table table-bordered table-striped table-hover table-sm mb-4 mt-3">';
$output .= "<tr bgcolor:grey>
           <th>No</th>
            <th>Cetak</th>
            <th>Tanggal</th>
            <th>Nama</th>
            <th>NIS</th>
            <th>Kelas</th>
            <th>ID Transaksi</th>
            <th>Record</th>
            <th>Jumlah</th>
            <th>Penerima</th>
    </tr>";

if (count($datas) > 0) {
    foreach ($datas as $data) {

        $format = new format();
        if ($data->setor == "Ya") {
            $setor = "Disetor";
        } else {
            $setor = "--";
        };
        $nis = $data->nis;
        $tahap = $data->tahap;
        //nama Bayar
        $classNB = new namaBayar();
        $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

        //startAt
        $classTr = new transaksi();
        $startAt = $classTr->startAt($tb_siswa, $nis);
        $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);
        $siswa_id = $crud->getValue($tb_siswa, "where nis='$nis'", 'id');

        //nama Bayar

        $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

        $showJenis = $classNB->shownamaBayar($tahun, $data->jenis, $data->jenjang);
        $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
        $field_tang = 'tang_' . $datajenis->kode;
        $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

        if ($setbulanan == "Tidak") {
            $periode = "Tahap " . $tahap;
        } else {
            $periode = $cekbulan;
        };

        //Proses Setor
        $clsSetor = new setor;
        $statusSetor = $clsSetor->statusSetor($data->setor);

        $link = new linkpage;
        $linkpost = new linkpost;
        $penerima = $classTr->namaPenerimaByID($data->penerima);


        $count = $crud->countData($tb_transaksi, "where id_tr='$data->id_tr'");
        $sum = $crud->sum($tb_transaksi, 'jumlah', "where id_tr='$data->id_tr'");
        $no++;
        $num = $no + $offset;


        $output .= "<tr>
                        <td width='5px'>$num</td> 
                        <td width='50px' align='center'>
                        <a " . $link->pageIDReprint($siswa_id, $data->id_tr, $tahun, 'transaksi/kuitansi_printpreview') . " class='badge badge-secondary  px-1 py-1 d-inline'> <i class='bi bi-printer'></i> CETAK</a>
                        </td>                                                   
                        <td align=center>" . $format->dateToIndo($data->tanggal) . "</td>
                        <td align=left>$data->nama</td>
                        <td align=center>$nis</td>
                        <td align=center>$data->jenjang - $data->paralel</td>
                        <td align=left>$data->id_tr</td>
                        <td align=left>$count</td>
                        <td align=right>" . $format->ribuan($sum) . "</td>
                        <td align=left>$penerima</td>  
                    </tr>";
    }
} else {
    $output .= '<tr>
        <td colspan="10">Tidak terdapat Data</td>
    </tr>';
}
$output .= '</table>';

$countRows = $crud->countData($tb_transaksi, " group by id_tr");

$queryTotal = "SELECT COUNT('id_tr') FROM $tb_transaksi WHERE nama LIKE :search || nis LIKE :search";
$stmtTotal = $pdo->prepare($queryTotal);
$stmtTotal->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmtTotal->execute();
$totalRows = $stmtTotal->fetchColumn();
$totalPages = ceil($countRows / $limit);
$output .= '<div>';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($i == $page) {
        $output .= "<button class='pagination_link btn-xs btn-default px-2 py-1 ml-1' data-page_number='{$i}'>{$i}</button>";
    } else {
        $output .= "<button class='pagination_link btn-xs btn-primary px-2 py-1 ml-1' data-page_number='{$i}'>{$i}</button>";
    };
}
$output .= '</div>';

echo $output;
